/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.terminal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import pl.jalokim.utils.constants.Constants;
import pl.jalokim.utils.string.StringUtils;
import pl.jalokim.utils.terminal.CommandException;

public final class TerminalCommandsInvoker {
    private static final String OS_NAME = "os.name";
    private static final String AMPERSANDS = " && ";

    private TerminalCommandsInvoker() {
    }

    public static boolean isLinux() {
        return TerminalCommandsInvoker.getOsName().contains("Linux");
    }

    public static boolean isWindows() {
        return TerminalCommandsInvoker.getOsName().contains("Windows");
    }

    public static String getOsName() {
        return System.getProperty(OS_NAME);
    }

    public static String invokeCommand(String path, String command) {
        return TerminalCommandsInvoker.invokeCommand(path, command, StandardCharsets.UTF_8);
    }

    public static String invokeCommand(String path, String command, Charset charset) {
        try {
            List<String> execCommands = TerminalCommandsInvoker.getExecCommands(path, command);
            String[] commandArgs = execCommands.toArray(new String[0]);
            ProcessBuilder builder = new ProcessBuilder(commandArgs);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            return TerminalCommandsInvoker.getResultAsText(charset, process);
        }
        catch (IOException ex) {
            throw new CommandException(ex);
        }
    }

    private static List<String> getExecCommands(String path, String command) {
        String moveToPathCommand = "cd " + path;
        ArrayList<String> execCommands = new ArrayList<String>();
        if (TerminalCommandsInvoker.isWindows()) {
            if (path.contains(":")) {
                String driveLetter = path.split(":")[0];
                moveToPathCommand = StringUtils.concat(driveLetter, ":", AMPERSANDS, moveToPathCommand);
            }
            execCommands.add("cmd.exe");
            execCommands.add("/c");
        } else if (TerminalCommandsInvoker.isLinux()) {
            execCommands.add("/bin/bash");
            execCommands.add("-c");
        } else {
            throw new CommandException("Not supported system: " + TerminalCommandsInvoker.getOsName());
        }
        String lastCommand = moveToPathCommand + AMPERSANDS + command;
        execCommands.add(lastCommand);
        return execCommands;
    }

    private static String getResultAsText(Charset charset, Process process) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line);
                result.append(Constants.NEW_LINE);
            }
            String string = result.toString();
            return string;
        }
    }
}

