/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.time;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.string.StringUtils;

public final class DurationFormatter {
    private DurationFormatter() {
    }

    public static String formatDuration(Duration duration) {
        return DurationFormatter.formatDuration(duration.toMillis());
    }

    public static String formatDuration(long durationInMs) {
        ArrayList<Long> timeSequence = new ArrayList<Long>();
        ArrayList<Integer> timeDividers = new ArrayList<Integer>(Arrays.asList(1000, 60, 60, 24));
        List<String> timeLabels = Arrays.asList("milliseconds", "seconds", "minutes", "hours", "days");
        timeDividers.add(1);
        long currentTime = durationInMs;
        for (int i = 0; i < timeDividers.size(); ++i) {
            Integer timeDivider = (Integer)timeDividers.get(i);
            if (currentTime >= (long)timeDivider.intValue() && !CollectionUtils.isLastIndex(timeDividers, i)) {
                long earlierTime = currentTime;
                long restOfTime = earlierTime - (currentTime /= (long)timeDivider.intValue()) * (long)timeDivider.intValue();
                if (restOfTime == (long)timeDivider.intValue()) {
                    currentTime = 1L;
                    continue;
                }
                timeSequence.add(restOfTime);
                continue;
            }
            timeSequence.add(currentTime);
            break;
        }
        ArrayList timeAsList = new ArrayList();
        Elements.elements(timeSequence).forEach((index, number) -> timeAsList.add(number.toString() + " " + (String)timeLabels.get((int)index)));
        Collections.reverse(timeAsList);
        return StringUtils.concatElements(timeAsList, " ");
    }
}

