/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.builder;

import java.lang.reflect.Field;
import pl.jsolve.sweetener.builder.InstanceFromParametrizedTypeCreator;
import pl.jsolve.sweetener.core.Objects;
import pl.jsolve.sweetener.exception.BuilderWithMethodBindingException;

public abstract class Builder<T> {
    private final T builtObject;
    private final InstanceFromParametrizedTypeCreator instanceCreator = new InstanceFromParametrizedTypeCreator(this.getClass());

    protected Builder(T builtObject) {
        this.builtObject = builtObject;
    }

    protected Builder() {
        this.builtObject = this.instanceCreator.createObjectFromParametrizedType();
    }

    public final <V> Builder<T> with(String fieldName, V fieldValue) {
        try {
            this.setBuildedObjectField(fieldName, fieldValue);
        }
        catch (Exception e) {
            throw new BuilderWithMethodBindingException(e, fieldName, Objects.nullSafeToString(fieldValue));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void setBuildedObjectField(String fieldName, V fieldValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.builtObject.getClass().getDeclaredField(fieldName);
        try {
            field.setAccessible(true);
            field.set(this.builtObject, fieldValue);
        }
        finally {
            field.setAccessible(false);
        }
    }

    protected final T getBuiltObject() {
        return this.builtObject;
    }

    public final T build() {
        return this.builtObject;
    }
}

