/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.builder;

import java.lang.reflect.ParameterizedType;
import pl.jsolve.sweetener.exception.InstanceCreationException;

public final class InstanceFromParametrizedTypeCreator {
    private static final int DEFUALT_PARAMETER_INDEX = 0;
    private final Class<?> genericClass;

    public InstanceFromParametrizedTypeCreator(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    public <T> T newInstance() {
        try {
            return (T)this.genericClass.newInstance();
        }
        catch (Exception e) {
            throw new InstanceCreationException("Cannot create new instance of class" + this.genericClass, e);
        }
    }

    public <T> T createObjectFromParametrizedType() {
        return this.createObjectFromParametrizedType(0);
    }

    public <T> T createObjectFromParametrizedType(int parameterIndex) {
        try {
            return this.getClassFromParameterizedType(parameterIndex).newInstance();
        }
        catch (Exception e) {
            throw new InstanceCreationException("Cannot create new instance of parametrized type", e);
        }
    }

    private <T> Class<T> getClassFromParameterizedType(int parameterIndex) {
        return (Class)this.getParameterizedType().getActualTypeArguments()[parameterIndex];
    }

    private ParameterizedType getParameterizedType() {
        return (ParameterizedType)this.genericClass.getGenericSuperclass();
    }
}

