/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.collection;

import java.util.Collection;
import java.util.List;
import pl.jsolve.sweetener.exception.PaginationException;

public class ChoppedElements<T> {
    private int page;
    private final int resultsPerPage;
    private final int totalElements;
    private final int numberOfPages;
    private final List<Collection<T>> listOfPages;

    public ChoppedElements(int page, int resultsPerPage, int totalElements, List<Collection<T>> listOfPages) {
        this.page = page;
        this.resultsPerPage = resultsPerPage;
        this.totalElements = totalElements;
        this.numberOfPages = this.calculateNumberOfPages(resultsPerPage, totalElements);
        this.listOfPages = listOfPages;
    }

    private int calculateNumberOfPages(int resultsPerPage, int totalElements) {
        return (totalElements + resultsPerPage - 1) / resultsPerPage;
    }

    public boolean hasNextPage() {
        return this.page + 1 <= this.numberOfPages;
    }

    public void nextPage() {
        if (this.page + 1 > this.numberOfPages) {
            throw new PaginationException("The next page does not exist");
        }
        ++this.page;
    }

    public boolean hasPreviousPage() {
        return this.page - 1 >= 0;
    }

    public void previousPage() {
        if (this.page - 1 < 0) {
            throw new PaginationException("The previous page does not exist");
        }
        --this.page;
    }

    public Collection<T> getElementsOfPage() {
        return this.listOfPages.get(this.page);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public List<Collection<T>> getListOfPages() {
        return this.listOfPages;
    }
}

