/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pl.jsolve.sweetener.collection.ChoppedElements;
import pl.jsolve.sweetener.collection.GroupKey;
import pl.jsolve.sweetener.collection.Maps;
import pl.jsolve.sweetener.collection.Pagination;
import pl.jsolve.sweetener.core.Reflections;
import pl.jsolve.sweetener.criteria.ComplexRestriction;
import pl.jsolve.sweetener.criteria.Criteria;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.exception.InvalidArgumentException;

public final class Collections {
    private Collections() {
        throw new AssertionError((Object)"Using constructor of this class is prohibited.");
    }

    public static <T> Collection<T> filter(Collection<T> collection, Criteria criteria) {
        Object result = Collections.createNewInstanceOfCollection(collection.getClass());
        for (T t : collection) {
            if (!Collections.checkIfElementSatisfiesConditions(t, criteria)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T extends Collection<E>, E> T truncate(T collection, int to) {
        return Collections.truncate(collection, 0, to);
    }

    public static <T extends Collection<E>, E> T truncate(T collection, int from, int to) {
        int countOfElements = collection.size();
        if (to < 0) {
            to = countOfElements + to;
        }
        if (from < 0) {
            throw new InvalidArgumentException("The 'From' value cannot be negative");
        }
        if (from > countOfElements - 1) {
            throw new InvalidArgumentException("The 'From' value cannot be greater than size of collection");
        }
        if (from > to) {
            throw new InvalidArgumentException("The 'From' value cannot be greater than the 'to' value");
        }
        if (to > countOfElements - 1) {
            throw new InvalidArgumentException("The 'To' value cannot be greater than size of collection");
        }
        Object result = Collections.createNewInstanceOfCollection(collection.getClass());
        Object[] array = collection.toArray();
        for (int i = from; i <= to; ++i) {
            result.add((Object)array[i]);
        }
        return (T)result;
    }

    public static <T extends Collection<E>, E> T createNewInstanceOfCollection(Class<T> clazz) {
        try {
            return (T)((Collection)clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkIfElementSatisfiesConditions(Object o, Criteria criteria) {
        for (Restriction restriction : criteria.getSortedRestrictions()) {
            Object fieldValue;
            if (!(restriction instanceof FieldRestriction ? !restriction.satisfies(fieldValue = Reflections.getFieldValue(o, ((FieldRestriction)restriction).getFieldName())) : restriction instanceof ComplexRestriction && !restriction.satisfies(o))) continue;
            return false;
        }
        return true;
    }

    public static <T> Pagination<T> paginate(Collection<T> collection, int page, int resultsPerPage) {
        int totalElements = collection.size();
        int from = page * resultsPerPage;
        int to = Collections.getTo(resultsPerPage, totalElements, from);
        Object elementsOfPage = Collections.createNewInstanceOfCollection(collection.getClass());
        if (from < collection.size()) {
            elementsOfPage = Collections.truncate(collection, from, to);
        }
        return new Pagination(page, resultsPerPage, totalElements, elementsOfPage);
    }

    public static <T> ChoppedElements<T> chopElements(Collection<T> collection, int resultsPerPage) {
        int totalElements = collection.size();
        int numberOfPages = (totalElements + resultsPerPage - 1) / resultsPerPage;
        ArrayList listOfPages = Collections.newArrayList();
        for (int i = 0; i < numberOfPages; ++i) {
            Collection<T> elementsOfPage = Collections.truncate(collection, i * resultsPerPage, Collections.getTo(resultsPerPage, totalElements, i * resultsPerPage));
            listOfPages.add(elementsOfPage);
        }
        return new ChoppedElements(0, resultsPerPage, totalElements, listOfPages);
    }

    private static int getTo(int resultsPerPage, int totalElements, int from) {
        int to = from + resultsPerPage;
        to = to > totalElements - 1 ? totalElements : to;
        return to - 1;
    }

    public static <E> Map<GroupKey, List<E>> group(Collection<E> collection, String ... properties) {
        HashMap<GroupKey, List<E>> map = Maps.newHashMap();
        for (E element : collection) {
            Object[] fieldValues = Collections.getFieldsValues(element, properties);
            GroupKey groupKey = new GroupKey(fieldValues);
            if (map.containsKey(groupKey)) {
                ((List)map.get(groupKey)).add(element);
                continue;
            }
            ArrayList<E> list = Collections.newArrayList();
            list.add(element);
            map.put(groupKey, list);
        }
        return map;
    }

    private static Object[] getFieldsValues(Object object, String ... property) {
        Object[] fieldValues = new Object[property.length];
        for (int i = 0; i < property.length; ++i) {
            fieldValues[i] = Reflections.getFieldValue(object, property[i]);
        }
        return fieldValues;
    }

    public static <E> Map<GroupKey, List<E>> duplicates(Collection<E> collection, String ... properties) {
        Map<GroupKey, List<E>> groups = Collections.group(collection, properties);
        ArrayList<GroupKey> keysToRemove = Collections.newArrayList();
        for (Map.Entry<GroupKey, List<E>> entry : groups.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            keysToRemove.add(entry.getKey());
        }
        for (GroupKey key : keysToRemove) {
            groups.remove(key);
        }
        return groups;
    }

    public static <E, T extends Collection<E>> T uniques(T collection, String ... properties) {
        Map<GroupKey, List<E>> groups = Collections.group(collection, properties);
        Object uniques = Collections.createNewInstanceOfCollection(collection.getClass());
        for (Map.Entry<GroupKey, List<E>> entry : groups.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            uniques.addAll((Collection)entry.getValue());
        }
        return (T)uniques;
    }

    public static <T extends Collection<?>> boolean containsAny(T collectionA, T collectionB) {
        return !java.util.Collections.disjoint(collectionA, collectionB);
    }

    public static <E, T extends Collection<E>> boolean containsAny(T collection, E[] elements) {
        return Collections.containsAny(collection, Arrays.asList(elements));
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList();
        java.util.Collections.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : elements) {
            arrayList.add(e);
        }
        return arrayList;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        return new ArrayList(initialArraySize);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    public static <E> LinkedList<E> newLinkedList(E ... elements) {
        LinkedList list = new LinkedList();
        java.util.Collections.addAll(list, elements);
        return list;
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> linkedList = new LinkedList<E>();
        for (E e : elements) {
            linkedList.add(e);
        }
        return linkedList;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet<E> set = Collections.newHashSet();
        java.util.Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSetWithInitialCapacity(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @SafeVarargs
    public static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        LinkedHashSet<E> set = Collections.newLinkedHashSet();
        java.util.Collections.addAll(set, elements);
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithInitialCapacity(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    @SafeVarargs
    public static <E extends Comparable<?>> TreeSet<E> newTreeSet(E ... elements) {
        TreeSet set = new TreeSet();
        java.util.Collections.addAll(set, elements);
        return set;
    }

    public static <E extends Comparable<?>> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet set = Collections.newTreeSet((Comparable[])new Comparable[0]);
        for (Comparable e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null");
        }
        return new TreeSet<E>(comparator);
    }
}

