/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.core.Condition;
import pl.jsolve.sweetener.core.ConditionFactory;
import pl.jsolve.sweetener.core.FieldWithOwner;
import pl.jsolve.sweetener.exception.AccessToFieldException;
import pl.jsolve.sweetener.exception.InstanceCreationException;

public final class Reflections {
    private static final String DOT = "\\.";
    private static final Condition<Class<?>> ALWAYS_SATISFIED_CLASS_CONDITION = ConditionFactory.createAlwaysSatisfiedCondition();
    private static final Condition<Field> ALWAYS_SATISFIED_FIELD_CONDITION = ConditionFactory.createAlwaysSatisfiedCondition();
    private static final Condition<Annotation> ALWAYS_SATISFIED_ANNOTATION_CONDITION = ConditionFactory.createAlwaysSatisfiedCondition();
    private static final Condition<Constructor<?>> ALWAYS_SATISFIED_CONSTRUCTOR_CONDITION = ConditionFactory.createAlwaysSatisfiedCondition();
    private static final Condition<Method> ALWAYS_SATISFIED_METHOD_CONDITION = ConditionFactory.createAlwaysSatisfiedCondition();

    private Reflections() {
        throw new AssertionError((Object)"Using constructor of this class is prohibited.");
    }

    public static Class<?> getFieldType(Object object, String stringOfFieldsName) {
        FieldWithOwner field = Reflections.getLastNestedField(object, stringOfFieldsName);
        Reflections.throwExceptonWhenFieldIsNotPresent(field, stringOfFieldsName);
        return field.getField().getType();
    }

    public static Object getFieldValue(Object object, String stringOfFieldsName) {
        FieldWithOwner field = Reflections.getLastNestedField(object, stringOfFieldsName);
        Reflections.throwExceptonWhenFieldIsNotPresent(field, stringOfFieldsName);
        return Reflections.getFieldValue(field.getOwner(), field.getField());
    }

    public static void setFieldValue(Object object, String stringOfFieldsName, Object value) {
        FieldWithOwner field = Reflections.getLastNestedField(object, stringOfFieldsName);
        Reflections.throwExceptonWhenFieldIsNotPresent(field, stringOfFieldsName);
        Reflections.setField(field.getOwner(), field.getField(), value);
    }

    private static void throwExceptonWhenFieldIsNotPresent(FieldWithOwner field, String stringOfFieldsName) {
        if (field == null) {
            throw new AccessToFieldException("The field %s does not exist", stringOfFieldsName);
        }
    }

    public static boolean isFieldPresent(Object object, String stringOfFieldsName) {
        return Reflections.getLastNestedField(object, stringOfFieldsName) != null;
    }

    private static FieldWithOwner getLastNestedField(Object object, String stringOfFieldsName) {
        String[] fieldsName = stringOfFieldsName.split(DOT);
        int levelOfNestedObject = 0;
        Class<?> clazz = object.getClass();
        while (!Object.class.equals(clazz)) {
            Class<?> nestedClass = clazz;
            for (int i = levelOfNestedObject; i < fieldsName.length; ++i) {
                boolean isLastNestedObject;
                Field field = Reflections.getDeclaredField(nestedClass, fieldsName[i]);
                if (field == null) continue;
                boolean bl = isLastNestedObject = i == fieldsName.length - 1;
                if (isLastNestedObject) {
                    return new FieldWithOwner(field, object);
                }
                Reflections.createValueIfNull(object, field);
                object = Reflections.getFieldValue(object, field);
                nestedClass = object.getClass();
                ++levelOfNestedObject;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static void createValueIfNull(Object object, Field field) {
        try {
            Object valueOfField = Reflections.getFieldValue(object, field);
            if (valueOfField == null) {
                Object newInstance = field.getType().newInstance();
                field.setAccessible(true);
                field.set(object, newInstance);
            }
        }
        catch (Exception ex) {
            throw new InstanceCreationException("Could not create new instance of " + field.getType(), ex);
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static void setField(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new AccessToFieldException("Exception during setting value of %s field\n%s", field.getName(), e.getMessage());
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static Object getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception e) {
            throw new AccessToFieldException("Exception during getting value of %s field", field.getName());
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<Class<?>> getClassesSatisfyingCondition(Class<?> clazz, Condition<Class<?>> classesCondition) {
        LinkedList<Class<?>> classes = Collections.newLinkedList();
        classes.add(clazz);
        while (!(Object.class.equals(clazz) || clazz.isInterface() || clazz.isPrimitive())) {
            if (!classesCondition.isSatisfied(clazz = clazz.getSuperclass())) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static List<Class<?>> getClassesSatisfyingCondition(Object object, Condition<Class<?>> classesCondition) {
        return Reflections.getClassesSatisfyingCondition(object.getClass(), classesCondition);
    }

    public static List<Class<?>> getClasses(Class<?> clazz) {
        return Reflections.getClassesSatisfyingCondition(clazz, ALWAYS_SATISFIED_CLASS_CONDITION);
    }

    public static List<Class<?>> getClasses(Object object) {
        return Reflections.getClassesSatisfyingCondition(object, ALWAYS_SATISFIED_CLASS_CONDITION);
    }

    public static List<Field> getFieldsSatisfyingCondition(Object object, Condition<Field> fieldCondition) {
        LinkedList<Field> fields = Collections.newLinkedList();
        Class<?> clazz = object.getClass();
        while (!Object.class.equals(clazz)) {
            Field[] arrayOfFields;
            for (Field field : arrayOfFields = clazz.getDeclaredFields()) {
                if (!fieldCondition.isSatisfied(field)) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getFields(Object object) {
        return Reflections.getFieldsSatisfyingCondition(object, ALWAYS_SATISFIED_FIELD_CONDITION);
    }

    public static List<Field> getFieldsAnnotatedBy(Object object, final Class<? extends Annotation> annotation) {
        return Reflections.getFieldsSatisfyingCondition(object, new Condition<Field>(){

            @Override
            public boolean isSatisfied(Field field) {
                return field.isAnnotationPresent(annotation);
            }
        });
    }

    public static List<Annotation> getAnnotationsSatisfyingCondition(Object object, Condition<Annotation> condition) {
        ArrayList<Annotation> annotations = Collections.newArrayList();
        Class<?> clazz = object.getClass();
        while (!Object.class.equals(clazz)) {
            Annotation[] arrayOfAnnotations;
            for (Annotation annotation : arrayOfAnnotations = clazz.getDeclaredAnnotations()) {
                if (!condition.isSatisfied(annotation)) continue;
                annotations.add(annotation);
            }
            clazz = clazz.getSuperclass();
        }
        return annotations;
    }

    public static List<Annotation> getAnnotations(Object object) {
        return Reflections.getAnnotationsSatisfyingCondition(object, ALWAYS_SATISFIED_ANNOTATION_CONDITION);
    }

    public static List<Constructor<?>> getConstructorsSatisfyingCondition(Object object, Condition<Constructor<?>> condition) {
        ArrayList<Constructor<?>> constructors = Collections.newArrayList();
        Class<?> clazz = object.getClass();
        while (!Object.class.equals(clazz)) {
            Constructor<?>[] declaredConstructors;
            for (Constructor<?> declaredConstructor : declaredConstructors = clazz.getDeclaredConstructors()) {
                if (!condition.isSatisfied(declaredConstructor)) continue;
                constructors.add(declaredConstructor);
            }
            clazz = clazz.getSuperclass();
        }
        return constructors;
    }

    public static List<Constructor<?>> getConstructors(Object object) {
        return Reflections.getConstructorsSatisfyingCondition(object, ALWAYS_SATISFIED_CONSTRUCTOR_CONDITION);
    }

    public static List<Method> getMethodsSatisfyingCondition(Object object, Condition<Method> methodsCondition) {
        ArrayList<Method> methods = Collections.newArrayList();
        Class<?> clazz = object.getClass();
        while (!Object.class.equals(clazz)) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
                if (!methodsCondition.isSatisfied(declaredMethod)) continue;
                methods.add(declaredMethod);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static List<Method> getMethods(Object object) {
        return Reflections.getMethodsSatisfyingCondition(object, ALWAYS_SATISFIED_METHOD_CONDITION);
    }

    public static List<Method> getMethodsAnnotatedBy(Object object, final Class<? extends Annotation> annotation) {
        return Reflections.getMethodsSatisfyingCondition(object, new Condition<Method>(){

            @Override
            public boolean isSatisfied(Method declaredMethod) {
                return declaredMethod.isAnnotationPresent(annotation);
            }
        });
    }

    public static <T> T tryToCreateNewInstance(Class<T> clazz) {
        try {
            return Reflections.tryToCreateNewInstance(clazz.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new InstanceCreationException("Could not create an instance of class " + clazz, e);
        }
    }

    public static <T> T tryToCreateNewInstance(Constructor constructor, Object ... params) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (ReflectiveOperationException e) {
            throw new InstanceCreationException("Could not create an instance of class " + constructor.getDeclaringClass(), e);
        }
    }
}

