/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.AggregationRange;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Avg
implements FieldRestriction {
    private static final Double DELTA = 1.0E-6;
    private final String fieldName;
    private final Double leftRange;
    private final AggregationRange aggregationRange;
    private final Double rightRange;

    public Avg(String fieldName, Double leftRange, Double rightRange, AggregationRange aggregationRange) {
        this.fieldName = fieldName;
        this.leftRange = leftRange;
        this.rightRange = rightRange == null ? leftRange : rightRange;
        this.aggregationRange = aggregationRange;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public Double getValue() {
        return this.leftRange;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                return Avg.this.forArray(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                return Avg.this.forCollection(elements);
            }

            @Override
            public boolean execute(Map elements) {
                throw new AccessToFieldException("Type mismatch. Expected List, Set or Array but was " + elements.getClass().getCanonicalName());
            }
        });
    }

    private boolean forArray(Object[] fieldValueAsArray) {
        double sum = 0.0;
        for (int i = 0; i < fieldValueAsArray.length; ++i) {
            if (!(fieldValueAsArray[i] instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValueAsArray[i].getClass().getCanonicalName());
            }
            sum += ((Number)fieldValueAsArray[i]).doubleValue();
        }
        double avg = sum / (double)fieldValueAsArray.length;
        if (Double.isNaN(avg)) {
            avg = 0.0;
        }
        return this.checkAvg(avg);
    }

    private boolean forCollection(Collection<?> fieldValueAsCollection) {
        double sum = 0.0;
        for (Object o : fieldValueAsCollection) {
            if (!(o instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + o.getClass().getCanonicalName());
            }
            sum += ((Number)o).doubleValue();
        }
        double avg = sum / (double)fieldValueAsCollection.size();
        if (Double.isNaN(avg)) {
            avg = 0.0;
        }
        return this.checkAvg(avg);
    }

    private boolean checkAvg(double avg) {
        switch (this.aggregationRange) {
            case LESS: {
                return avg < this.leftRange;
            }
            case GREATER: {
                return avg > this.leftRange;
            }
            case BETWEEN: {
                return avg >= this.leftRange && avg <= this.rightRange;
            }
            case NOT_BETWEEN: {
                return avg < this.leftRange || avg > this.rightRange;
            }
            case EQUALS: {
                return Math.abs(avg - this.leftRange) <= DELTA;
            }
            case NOT_EQUALS: {
                return !(Math.abs(avg - this.leftRange) <= DELTA);
            }
        }
        return false;
    }
}

