/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Date;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.DateExtractor;
import pl.jsolve.sweetener.exception.InvalidArgumentException;

public class Before
implements FieldRestriction {
    private final String fieldName;
    private final Date value;
    private final Map<Class<?>, DateExtractor> dateExtractors;

    public Before(String fieldName, Object date, Map<Class<?>, DateExtractor> dateExtractors) {
        this.fieldName = fieldName;
        this.dateExtractors = dateExtractors;
        if (date instanceof Date) {
            this.value = (Date)date;
        } else if (dateExtractors.containsKey(date.getClass())) {
            this.value = this.extractDate(date);
        } else {
            throw new InvalidArgumentException("Cannot find date extractor for class " + date.getClass().getCanonicalName());
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public Date getValue() {
        return this.value;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue != null) {
            if (fieldValue instanceof Date) {
                return this.isBefore((Date)fieldValue, this.value);
            }
            if (this.dateExtractors.containsKey(fieldValue.getClass())) {
                Date extractedDate = this.extractDate(fieldValue);
                return this.isBefore(extractedDate, this.value);
            }
        }
        return false;
    }

    private Date extractDate(Object fieldValue) {
        DateExtractor dateExtractor = this.dateExtractors.get(fieldValue.getClass());
        return dateExtractor.extract(fieldValue);
    }

    private boolean isBefore(Date extractedValue, Date threshold) {
        return threshold.getTime() > extractedValue.getTime();
    }
}

