/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.exception.AccessToFieldException;

class CollectionExecutor {
    CollectionExecutor() {
    }

    public boolean perform(Object elements, Executor executor) {
        if (!(elements instanceof Collection) && !elements.getClass().isArray()) {
            throw new AccessToFieldException("Type mismatch. Expected Collection, Map or Array but was " + elements.getClass().getCanonicalName());
        }
        if (elements instanceof Collection) {
            return executor.execute((Collection)elements);
        }
        if (elements instanceof Map) {
            return executor.execute((Map)elements);
        }
        if (elements.getClass().isArray()) {
            Object[] fieldValueAsArray = null;
            try {
                fieldValueAsArray = (Object[])elements;
            }
            catch (ClassCastException ex) {
                int length = Array.getLength(elements);
                fieldValueAsArray = new Object[length];
                for (int i = 0; i < Array.getLength(elements); ++i) {
                    fieldValueAsArray[i] = Array.get(elements, i);
                }
            }
            return executor.execute(fieldValueAsArray);
        }
        return true;
    }

    public static interface Executor {
        public boolean execute(Collection var1);

        public boolean execute(Map var1);

        public boolean execute(Object[] var1);
    }
}

