/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;

public class Contains
implements FieldRestriction {
    private final String fieldName;
    private final boolean exactlyAllObjects;
    private final Object[] value;

    public Contains(String fieldName, boolean exactlyAllObjects, Object[] value) {
        this.fieldName = fieldName;
        this.exactlyAllObjects = exactlyAllObjects;
        this.value = value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isExactlyAllObjects() {
        return this.exactlyAllObjects;
    }

    public Object[] getValue() {
        return this.value;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                if (Contains.this.exactlyAllObjects) {
                    return Contains.this.forExactlyAllObjects(elements);
                }
                return Contains.this.forAnyObject(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                if (Contains.this.exactlyAllObjects) {
                    return Contains.this.forExactlyAllObjects(elements);
                }
                return Contains.this.forAnyObject(elements);
            }

            @Override
            public boolean execute(Map elements) {
                if (Contains.this.exactlyAllObjects) {
                    return Contains.this.forExactlyAllObjects(elements);
                }
                return Contains.this.forAnyObject(elements);
            }
        });
    }

    private boolean forAnyObject(Object[] fieldValueAsArray) {
        for (Object o : this.value) {
            for (int i = 0; i < fieldValueAsArray.length; ++i) {
                if (!fieldValueAsArray[i].equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean forExactlyAllObjects(Object[] fieldValueAsArray) {
        for (Object o : this.value) {
            for (int i = 0; i < fieldValueAsArray.length; ++i) {
                if (fieldValueAsArray[i].equals(o)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean forExactlyAllObjects(Collection<?> fieldValueAsCollection) {
        for (Object o : this.value) {
            if (fieldValueAsCollection.contains(o)) continue;
            return false;
        }
        return true;
    }

    private boolean forAnyObject(Collection<?> fieldValueAsCollection) {
        for (Object o : this.value) {
            if (!fieldValueAsCollection.contains(o)) continue;
            return true;
        }
        return false;
    }

    private boolean forExactlyAllObjects(Map<?, ?> fieldValueAsMap) {
        Set<?> keySet = fieldValueAsMap.keySet();
        return this.forExactlyAllObjects(keySet);
    }

    private boolean forAnyObject(Map<?, ?> fieldValueAsMap) {
        Set<?> keySet = fieldValueAsMap.keySet();
        return this.forAnyObject(keySet);
    }
}

