/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.AggregationRange;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Count
implements FieldRestriction {
    private final String fieldName;
    private final Integer leftRange;
    private final AggregationRange aggregationRange;
    private final Integer rightRange;

    public Count(String fieldName, Integer leftRange, Integer rightRange, AggregationRange aggregationRange) {
        this.fieldName = fieldName;
        this.leftRange = leftRange;
        this.rightRange = rightRange == null ? leftRange : rightRange;
        this.aggregationRange = aggregationRange;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                return Count.this.forArray(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                return Count.this.forCollection(elements);
            }

            @Override
            public boolean execute(Map elements) {
                throw new AccessToFieldException("Type mismatch. Expected List, Set or Array but was " + elements.getClass().getCanonicalName());
            }
        });
    }

    private boolean forArray(Object[] fieldValueAsArray) {
        return this.checkCount(fieldValueAsArray.length);
    }

    private boolean forCollection(Collection<?> fieldValueAsCollection) {
        return this.checkCount(fieldValueAsCollection.size());
    }

    private boolean checkCount(int count) {
        switch (this.aggregationRange) {
            case LESS: {
                return count < this.leftRange;
            }
            case GREATER: {
                return count > this.leftRange;
            }
            case BETWEEN: {
                return count >= this.leftRange && count <= this.rightRange;
            }
            case NOT_BETWEEN: {
                return count < this.leftRange || count > this.rightRange;
            }
            case EQUALS: {
                return count == this.leftRange;
            }
            case NOT_EQUALS: {
                return count != this.leftRange;
            }
        }
        return false;
    }
}

