/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class LessOrEquals
implements FieldRestriction {
    private final String fieldName;
    private final Number value;

    public LessOrEquals(String fieldName, Number value) {
        this.fieldName = fieldName;
        this.value = value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue != null) {
            if (!(fieldValue instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValue.getClass().getCanonicalName());
            }
            return ((Number)fieldValue).doubleValue() <= this.value.doubleValue();
        }
        return false;
    }
}

