/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Like
implements FieldRestriction {
    private final String fieldName;
    private final String value;
    private final boolean ignoreCase;

    public Like(String fieldName, String value) {
        this.fieldName = fieldName;
        this.value = value;
        this.ignoreCase = false;
    }

    public Like(String fieldName, String value, boolean ignoreCase) {
        this.fieldName = fieldName;
        this.value = value;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.MEDIUM;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue != null) {
            if (!(fieldValue instanceof String)) {
                throw new AccessToFieldException("Type mismatch. Expected String but was " + this.value.getClass().getCanonicalName());
            }
            return this.satisfiesString((String)fieldValue);
        }
        return false;
    }

    private boolean satisfiesString(String fieldValue) {
        if (this.ignoreCase) {
            return fieldValue.toLowerCase().contains(this.value.toLowerCase());
        }
        return fieldValue.contains(this.value);
    }
}

