/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.AggregationRange;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Max
implements FieldRestriction {
    private static final Double DELTA = 1.0E-6;
    private final String fieldName;
    private final Number leftRange;
    private final AggregationRange aggregationRange;
    private final Number rightRange;

    public Max(String fieldName, Number leftRange, Number rightRange, AggregationRange aggregationRange) {
        this.fieldName = fieldName;
        this.leftRange = leftRange;
        this.rightRange = rightRange == null ? (Number)leftRange : (Number)rightRange;
        this.aggregationRange = aggregationRange;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                return Max.this.forArray(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                return Max.this.forCollection(elements);
            }

            @Override
            public boolean execute(Map elements) {
                throw new AccessToFieldException("Type mismatch. Expected List, Set or Array but was " + elements.getClass().getCanonicalName());
            }
        });
    }

    private boolean forArray(Object[] fieldValueAsArray) {
        Double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < fieldValueAsArray.length; ++i) {
            if (!(fieldValueAsArray[i] instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValueAsArray[i].getClass().getCanonicalName());
            }
            double doubleValue = ((Number)fieldValueAsArray[i]).doubleValue();
            if (!(maxValue < doubleValue)) continue;
            maxValue = doubleValue;
        }
        return this.checkMax(maxValue);
    }

    private boolean forCollection(Collection<?> fieldValueAsCollection) {
        Double maxValue = Double.MIN_VALUE;
        for (Object o : fieldValueAsCollection) {
            if (!(o instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + o.getClass().getCanonicalName());
            }
            double doubleValue = ((Number)o).doubleValue();
            if (!(maxValue < doubleValue)) continue;
            maxValue = doubleValue;
        }
        return this.checkMax(maxValue);
    }

    private boolean checkMax(Double maxValue) {
        switch (this.aggregationRange) {
            case LESS: {
                return maxValue < this.leftRange.doubleValue();
            }
            case GREATER: {
                return maxValue > this.leftRange.doubleValue();
            }
            case BETWEEN: {
                return maxValue >= this.leftRange.doubleValue() && maxValue <= this.rightRange.doubleValue();
            }
            case NOT_BETWEEN: {
                return maxValue < this.leftRange.doubleValue() || maxValue > this.rightRange.doubleValue();
            }
            case EQUALS: {
                return Math.abs(maxValue - this.leftRange.doubleValue()) <= DELTA;
            }
            case NOT_EQUALS: {
                return Math.abs(maxValue - this.leftRange.doubleValue()) > DELTA;
            }
        }
        return false;
    }
}

