/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.AggregationRange;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Min
implements FieldRestriction {
    private static final Double DELTA = 1.0E-6;
    private final String fieldName;
    private final Number leftRange;
    private final AggregationRange aggregationRange;
    private final Number rightRange;

    public Min(String fieldName, Number leftRange, Number rightRange, AggregationRange aggregationRange) {
        this.fieldName = fieldName;
        this.leftRange = leftRange;
        this.rightRange = rightRange == null ? (Number)leftRange : (Number)rightRange;
        this.aggregationRange = aggregationRange;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                return Min.this.forArray(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                return Min.this.forCollection(elements);
            }

            @Override
            public boolean execute(Map elements) {
                throw new AccessToFieldException("Type mismatch. Expected List, Set or Array but was " + elements.getClass().getCanonicalName());
            }
        });
    }

    private boolean forArray(Object[] fieldValueAsArray) {
        Double minValue = Double.MAX_VALUE;
        for (int i = 0; i < fieldValueAsArray.length; ++i) {
            if (!(fieldValueAsArray[i] instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValueAsArray[i].getClass().getCanonicalName());
            }
            double doubleValue = ((Number)fieldValueAsArray[i]).doubleValue();
            if (!(minValue > doubleValue)) continue;
            minValue = doubleValue;
        }
        return this.checkMin(minValue);
    }

    private boolean forCollection(Collection<?> fieldValueAsCollection) {
        Double minValue = Double.MAX_VALUE;
        for (Object o : fieldValueAsCollection) {
            if (!(o instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + o.getClass().getCanonicalName());
            }
            double doubleValue = ((Number)o).doubleValue();
            if (!(minValue > doubleValue)) continue;
            minValue = doubleValue;
        }
        return this.checkMin(minValue);
    }

    private boolean checkMin(Double minValue) {
        switch (this.aggregationRange) {
            case LESS: {
                return minValue < this.leftRange.doubleValue();
            }
            case GREATER: {
                return minValue > this.leftRange.doubleValue();
            }
            case BETWEEN: {
                return minValue >= this.leftRange.doubleValue() && minValue <= this.rightRange.doubleValue();
            }
            case NOT_BETWEEN: {
                return minValue < this.leftRange.doubleValue() || minValue > this.rightRange.doubleValue();
            }
            case EQUALS: {
                return Math.abs(minValue - this.leftRange.doubleValue()) <= DELTA;
            }
            case NOT_EQUALS: {
                return Math.abs(minValue - this.leftRange.doubleValue()) > DELTA;
            }
        }
        return false;
    }
}

