/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.exception.AccessToFieldException;
import pl.jsolve.sweetener.exception.InvalidArgumentException;

public class NotBetween
implements FieldRestriction {
    private final String fieldName;
    private final Number minValue;
    private final Number maxValue;
    private final boolean leftInclusive;
    private final boolean rightInclusive;

    public NotBetween(String fieldName, Number minValue, Number maxValue) {
        this.checkRange(minValue, maxValue);
        this.fieldName = fieldName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.leftInclusive = true;
        this.rightInclusive = true;
    }

    public NotBetween(String fieldName, Number minValue, Number maxValue, boolean leftInclusive, boolean rightInclusive) {
        this.checkRange(minValue, maxValue);
        this.fieldName = fieldName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.leftInclusive = leftInclusive;
        this.rightInclusive = rightInclusive;
    }

    private void checkRange(Number minValue, Number maxValue) {
        if (minValue == null) {
            throw new InvalidArgumentException("The lower range cannot be null");
        }
        if (maxValue == null) {
            throw new InvalidArgumentException("The upper range cannot be null");
        }
        if (minValue.doubleValue() > maxValue.doubleValue()) {
            throw new InvalidArgumentException("The lower range cannot be greater than the upper range");
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public boolean isLeftInclusive() {
        return this.leftInclusive;
    }

    public boolean isRightInclusive() {
        return this.rightInclusive;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue != null) {
            if (!(fieldValue instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValue.getClass().getCanonicalName());
            }
            if (this.leftInclusive) {
                if (this.rightInclusive) {
                    return !(((Number)fieldValue).doubleValue() >= this.minValue.doubleValue()) || !(((Number)fieldValue).doubleValue() <= this.maxValue.doubleValue());
                }
                return !(((Number)fieldValue).doubleValue() >= this.minValue.doubleValue()) || !(((Number)fieldValue).doubleValue() < this.maxValue.doubleValue());
            }
            if (this.rightInclusive) {
                return !(((Number)fieldValue).doubleValue() > this.minValue.doubleValue()) || !(((Number)fieldValue).doubleValue() <= this.maxValue.doubleValue());
            }
            return !(((Number)fieldValue).doubleValue() > this.minValue.doubleValue()) || !(((Number)fieldValue).doubleValue() < this.maxValue.doubleValue());
        }
        return false;
    }
}

