/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class NotEquals
implements FieldRestriction {
    private final String fieldName;
    private final Object value;
    private final boolean ignoreCase;

    public NotEquals(String fieldName, Object value) {
        this.fieldName = fieldName;
        this.value = value;
        this.ignoreCase = false;
    }

    public NotEquals(String fieldName, Object value, boolean ignoreCase) {
        this.fieldName = fieldName;
        this.value = value;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.MEDIUM;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                return this.satisfiesString((String)fieldValue);
            }
            return !fieldValue.equals(this.value);
        }
        return false;
    }

    private boolean satisfiesString(String fieldValue) {
        if (!(this.value instanceof String)) {
            throw new AccessToFieldException("Type mismatch. Expected String but was " + this.value.getClass().getCanonicalName());
        }
        if (this.ignoreCase) {
            return !fieldValue.equalsIgnoreCase((String)this.value);
        }
        return !fieldValue.equals(this.value);
    }
}

