/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.criteria.restriction;

import java.util.Collection;
import java.util.Map;
import pl.jsolve.sweetener.criteria.FieldRestriction;
import pl.jsolve.sweetener.criteria.Restriction;
import pl.jsolve.sweetener.criteria.restriction.AggregationRange;
import pl.jsolve.sweetener.criteria.restriction.CollectionExecutor;
import pl.jsolve.sweetener.exception.AccessToFieldException;

public class Sum
implements FieldRestriction {
    private static final Double DELTA = 1.0E-6;
    private final String fieldName;
    private final Number leftRange;
    private final AggregationRange aggregationRange;
    private final Number rightRange;

    public Sum(String fieldName, Number leftRange, Number rightRange, AggregationRange aggregationRange) {
        this.fieldName = fieldName;
        this.leftRange = leftRange;
        this.rightRange = rightRange == null ? (Number)leftRange : (Number)rightRange;
        this.aggregationRange = aggregationRange;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Restriction.RestrictionLevel getRestrictionLevel() {
        return Restriction.RestrictionLevel.LOW;
    }

    @Override
    public boolean satisfies(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        CollectionExecutor executor = new CollectionExecutor();
        return executor.perform(fieldValue, new CollectionExecutor.Executor(){

            @Override
            public boolean execute(Object[] elements) {
                return Sum.this.forArray(elements);
            }

            @Override
            public boolean execute(Collection elements) {
                return Sum.this.forCollection(elements);
            }

            @Override
            public boolean execute(Map elements) {
                throw new AccessToFieldException("Type mismatch. Expected List, Set or Array but was " + elements.getClass().getCanonicalName());
            }
        });
    }

    private boolean forArray(Object[] fieldValueAsArray) {
        double sum = 0.0;
        for (int i = 0; i < fieldValueAsArray.length; ++i) {
            if (!(fieldValueAsArray[i] instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + fieldValueAsArray[i].getClass().getCanonicalName());
            }
            sum += ((Number)fieldValueAsArray[i]).doubleValue();
        }
        return this.checkSum(sum);
    }

    private boolean forCollection(Collection<?> fieldValueAsCollection) {
        double sum = 0.0;
        for (Object o : fieldValueAsCollection) {
            if (!(o instanceof Number)) {
                throw new AccessToFieldException("Type mismatch. Expected Number but was " + o.getClass().getCanonicalName());
            }
            sum += ((Number)o).doubleValue();
        }
        return this.checkSum(sum);
    }

    private boolean checkSum(double sum) {
        switch (this.aggregationRange) {
            case LESS: {
                return sum < this.leftRange.doubleValue();
            }
            case GREATER: {
                return sum > this.leftRange.doubleValue();
            }
            case BETWEEN: {
                return sum >= this.leftRange.doubleValue() && sum <= this.rightRange.doubleValue();
            }
            case NOT_BETWEEN: {
                return sum < this.leftRange.doubleValue() || sum > this.rightRange.doubleValue();
            }
            case EQUALS: {
                return Math.abs(sum - this.leftRange.doubleValue()) <= DELTA;
            }
            case NOT_EQUALS: {
                return Math.abs(sum - this.leftRange.doubleValue()) > DELTA;
            }
        }
        return false;
    }
}

