/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.io;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import pl.jsolve.sweetener.collection.Collections;

public class Finder
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcher;
    private final List<Path> paths = Collections.newArrayList();

    Finder(String pattern) {
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    void find(Path file) {
        Path fileName = file.getFileName();
        if (fileName != null && this.matcher.matches(fileName)) {
            this.paths.add(file);
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        this.find(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        this.find(dir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    List<Path> getPaths() {
        return this.paths;
    }
}

