/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.exception.ResourceException;
import pl.jsolve.sweetener.io.Finder;

public final class Resources {
    private static final String NEW_LINE = "\n";

    private Resources() {
        throw new AssertionError((Object)"Using constructor of this class is prohibited.");
    }

    public static List<Path> findFilePaths(String fileName) {
        return Resources.findPaths("", fileName);
    }

    public static List<Path> findFilePaths(String startingDir, String fileName) {
        return Resources.findPaths(startingDir, fileName);
    }

    private static List<Path> findPaths(String startingDirAsString, String fileName) {
        try {
            Path startingDir = Paths.get(startingDirAsString, new String[0]);
            Finder finder = new Finder(fileName);
            Files.walkFileTree(startingDir, finder);
            return finder.getPaths();
        }
        catch (IOException ioe) {
            return Collections.newArrayList();
        }
    }

    public static File asFile(Path path) {
        return path.toFile();
    }

    public static File asFile(URL url, String fileName) {
        File file = new File(fileName);
        return Resources.asFile(url, file);
    }

    public static File asFile(URL url, File file) {
        try {
            InputStream in = url.openStream();
            FileOutputStream outputStream = new FileOutputStream(file);
            Resources.asOutputStream(in, outputStream);
            return file;
        }
        catch (Exception ex) {
            throw new ResourceException(url.toString(), ex);
        }
    }

    public static OutputStream asOutputStream(InputStream is, OutputStream os) {
        try {
            int read;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            return os;
        }
        catch (Exception ex) {
            throw new ResourceException(ex);
        }
    }

    public static List<String> asListOfLines(Path path) {
        FileReader fileReader = Resources.createFileReader(path);
        return Resources.readLines(fileReader);
    }

    private static FileReader createFileReader(Path path) {
        try {
            return new FileReader(path.toFile());
        }
        catch (IOException ex) {
            throw new pl.jsolve.sweetener.exception.FileNotFoundException(path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(Reader fileReader) {
        ArrayList<String> arrayList;
        ArrayList<String> lines = Collections.newArrayList();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                lines.add(line);
                line = bufferedReader.readLine();
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ResourceException(ex);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public static List<String> asListOfLines(URL url) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(url.openStream());
            return Resources.readLines(inputStreamReader);
        }
        catch (IOException e) {
            throw new ResourceException(url.toString(), e);
        }
    }

    public static String asString(Path path) {
        List<String> lines = Resources.asListOfLines(path);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String asString(URL url) {
        List<String> lines = Resources.asListOfLines(url);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(NEW_LINE);
        }
        return sb.toString();
    }

    public static InputStream asInputStream(Path path) {
        try {
            return new FileInputStream(path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new pl.jsolve.sweetener.exception.FileNotFoundException(path.toString());
        }
    }

    public static InputStream asInputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new ResourceException(url.toString(), e);
        }
    }

    public static void closeStream(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }
}

