/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.core.Objects;
import pl.jsolve.sweetener.exception.InvalidArgumentException;
import pl.jsolve.sweetener.exception.OutOfRangeException;
import pl.jsolve.sweetener.exception.ParseException;
import pl.jsolve.sweetener.math.Generator;
import pl.jsolve.sweetener.math.MinMaxValue;
import pl.jsolve.sweetener.math.ParseContext;
import pl.jsolve.sweetener.math.Point2D;
import pl.jsolve.sweetener.math.Point3D;
import pl.jsolve.sweetener.math.RandomGenerator;

public class Maths {
    private static Generator randomGenerator = new RandomGenerator();

    public static byte random(byte lowerRange, byte upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static byte random(byte lowerRange, byte upperRange, Generator generator) {
        byte result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        byte range = (byte)(upperRange - lowerRange);
        double random = generator.generate();
        if (range < 0) {
            int intRange = upperRange - lowerRange + 1;
            result = (byte)(lowerRange + (int)(random * (double)intRange));
        } else {
            result = (byte)(lowerRange + (int)(random * (double)(range + 1)));
        }
        return random == 1.0 ? (byte)(result - 1) : result;
    }

    public static short random(short lowerRange, short upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static short random(short lowerRange, short upperRange, Generator generator) {
        short result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        short range = (short)(upperRange - lowerRange);
        double random = generator.generate();
        if (range < 0) {
            int intRange = upperRange - lowerRange + 1;
            result = (short)(lowerRange + (int)(random * (double)intRange));
        } else {
            result = (short)(lowerRange + (int)(random * (double)(range + 1)));
        }
        return random == 1.0 ? (short)(result - 1) : result;
    }

    public static int random(int lowerRange, int upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static int random(int lowerRange, int upperRange, Generator generator) {
        int result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        int range = upperRange - lowerRange;
        double random = generator.generate();
        if (range < 0) {
            long longRange = (long)upperRange - (long)lowerRange + 1L;
            result = (int)((long)lowerRange + (long)(random * (double)longRange));
        } else {
            result = (int)((long)lowerRange + (long)(random * (double)(range + 1)));
        }
        return random == 1.0 ? result - 1 : result;
    }

    public static long random(long lowerRange, long upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static long random(long lowerRange, long upperRange, Generator generator) {
        long result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        long range = upperRange - lowerRange;
        double random = generator.generate();
        if (range < 0L) {
            BigDecimal bigIntegerRange = BigDecimal.valueOf(upperRange).subtract(BigDecimal.valueOf(lowerRange)).add(BigDecimal.ONE);
            result = BigDecimal.valueOf(lowerRange).add(BigDecimal.valueOf(random).multiply(bigIntegerRange)).setScale(0, RoundingMode.HALF_UP).longValue();
        } else {
            result = lowerRange + (long)(random * (double)(range + 1L));
        }
        return random == 1.0 ? result - 1L : result;
    }

    public static float random(float lowerRange, float upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static float random(float lowerRange, float upperRange, Generator generator) {
        float result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        float range = upperRange - lowerRange;
        if (range < 0.0f) {
            double longRange = (double)upperRange - (double)lowerRange;
            result = (float)((double)lowerRange + generator.generate() * longRange);
        } else {
            result = (float)((double)lowerRange + generator.generate() * (double)range);
        }
        return result;
    }

    public static double random(double lowerRange, double upperRange) {
        return Maths.random(lowerRange, upperRange, randomGenerator);
    }

    public static double random(double lowerRange, double upperRange, Generator generator) {
        double result;
        if (lowerRange > upperRange) {
            throw new InvalidArgumentException("Lower range cannot be greater than or equal to upper range");
        }
        double range = upperRange - lowerRange;
        if (range < 0.0) {
            BigDecimal bigIntegerRange = BigDecimal.valueOf(upperRange).subtract(BigDecimal.valueOf(lowerRange));
            result = BigDecimal.valueOf(lowerRange).add(BigDecimal.valueOf(generator.generate()).multiply(bigIntegerRange)).setScale(0, RoundingMode.HALF_UP).longValue();
        } else {
            result = lowerRange + generator.generate() * range;
        }
        return result;
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static double distance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static double distance(Point2D p1, Point2D p2) {
        return Maths.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double distance(Point3D p1, Point3D p2) {
        return Maths.distance(p1.getX(), p1.getY(), p1.getZ(), p2.getX(), p2.getY(), p2.getZ());
    }

    public static byte parseByte(String value) {
        return Maths.parseByte(value, ParseContext.TRY_ADJUST);
    }

    public static byte parseByte(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            return Byte.valueOf(value.trim());
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, (byte)-128, (byte)127, (byte)0);
        }
    }

    public static short parseShort(String value) {
        return Maths.parseShort(value, ParseContext.TRY_ADJUST);
    }

    public static short parseShort(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            return Short.valueOf(value.trim());
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)0);
        }
    }

    public static int parseInteger(String value) {
        return Maths.parseInteger(value, ParseContext.TRY_ADJUST);
    }

    public static int parseInteger(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        }
    }

    public static long parseLong(String value) {
        return Maths.parseLong(value, ParseContext.TRY_ADJUST);
    }

    public static long parseLong(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, Long.MIN_VALUE, Long.MAX_VALUE, 0L);
        }
    }

    public static float parseFloat(String value) {
        return Maths.parseFloat(value, ParseContext.TRY_ADJUST);
    }

    public static float parseFloat(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            Float f = Float.valueOf(value.trim());
            if (f.floatValue() == Float.NEGATIVE_INFINITY || f.floatValue() == Float.POSITIVE_INFINITY) {
                throw new NumberFormatException("Overflow");
            }
            return f.floatValue();
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(0.0f)).floatValue();
        }
    }

    public static double parseDouble(String value) {
        return Maths.parseDouble(value, ParseContext.TRY_ADJUST);
    }

    public static double parseDouble(String value, ParseContext context) {
        try {
            value = Objects.nullSafeToString(value);
            Double d = Double.valueOf(value.trim());
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                throw new NumberFormatException("Overflow");
            }
            return d;
        }
        catch (NumberFormatException ex) {
            return Maths.parseByBigDecimal(value.trim(), context, Double.MIN_VALUE, Double.MAX_VALUE, 0.0);
        }
    }

    private static <T> T parseByBigDecimal(String value, ParseContext context, T minValue, T maxValue, T zero) {
        try {
            Double d;
            Float f;
            BigDecimal valueAsBigDecimal = new BigDecimal(value);
            if (minValue instanceof Byte) {
                valueAsBigDecimal.byteValueExact();
            }
            if (minValue instanceof Short) {
                valueAsBigDecimal.shortValueExact();
            }
            if (minValue instanceof Integer) {
                valueAsBigDecimal.intValueExact();
            }
            if (minValue instanceof Long) {
                valueAsBigDecimal.longValueExact();
            }
            if (minValue instanceof Float && ((f = Float.valueOf(valueAsBigDecimal.floatValue())).floatValue() == Float.NEGATIVE_INFINITY || f.floatValue() == Float.POSITIVE_INFINITY)) {
                throw new ArithmeticException("Overflow");
            }
            if (minValue instanceof Double && ((d = Double.valueOf(valueAsBigDecimal.doubleValue())) == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY)) {
                throw new ArithmeticException("Overflow");
            }
        }
        catch (Exception ex) {
            return Maths.adjustToContext(value, context, ex, minValue, maxValue, zero);
        }
        return zero;
    }

    private static <T> T adjustToContext(String value, ParseContext context, Exception ex, T minValue, T maxValue, T zero) {
        switch (context) {
            case ALWAYS_ZERO: {
                return zero;
            }
            case ZERO_WHEN_INCORRECT: {
                try {
                    Maths.parseException(value, ex);
                    break;
                }
                catch (ParseException e) {
                    return zero;
                }
            }
            case TRY_ADJUST: {
                try {
                    Maths.parseException(value, ex);
                }
                catch (ParseException e) {
                    return zero;
                }
                catch (OutOfRangeException oe) {
                    if (oe.getRange() == OutOfRangeException.Range.MIN) {
                        return minValue;
                    }
                    return maxValue;
                }
            }
            default: {
                Maths.parseException(value, ex);
            }
        }
        return zero;
    }

    private static void parseException(String value, Exception ex) {
        String message = ex.getMessage();
        if (message != null && message.startsWith("Overflow")) {
            if (value.charAt(0) == '-') {
                throw new OutOfRangeException(ex, OutOfRangeException.Range.MIN);
            }
            throw new OutOfRangeException(ex, OutOfRangeException.Range.MAX);
        }
        throw new ParseException(ex);
    }

    public static double normalize(byte value, byte minValue, byte maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %d is out of the range: <%d, %d>", value, minValue, maxValue));
        }
        return (double)(value - minValue) / (double)(maxValue - minValue);
    }

    public static double normalize(short value, short minValue, short maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %d is out of the range: <%d, %d>", value, minValue, maxValue));
        }
        return (double)(value - minValue) / (double)(maxValue - minValue);
    }

    public static double normalize(int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %d is out of the range: <%d, %d>", value, minValue, maxValue));
        }
        return (double)(value - minValue) / (double)(maxValue - minValue);
    }

    public static double normalize(long value, long minValue, long maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %d is out of the range: <%d, %d>", value, minValue, maxValue));
        }
        return (double)(value - minValue) / (double)(maxValue - minValue);
    }

    public static double normalize(float value, float minValue, float maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %f is out of the range: <%f; %f>", Float.valueOf(value), Float.valueOf(minValue), Float.valueOf(maxValue)));
        }
        return (double)(value - minValue) / (double)(maxValue - minValue);
    }

    public static double normalize(double value, double minValue, double maxValue) {
        if (value < minValue || value > maxValue) {
            throw new OutOfRangeException(String.format("The value %f is out of the range: <%f; %f>", value, minValue, maxValue));
        }
        return (value - minValue) / (maxValue - minValue);
    }

    public static MinMaxValue<Byte> minMaxByte(Collection<Byte> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Byte min = 127;
        Byte max = -128;
        for (Byte value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Byte>(min, max);
    }

    public static MinMaxValue<Short> minMaxShort(Collection<Short> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Short min = Short.MAX_VALUE;
        Short max = Short.MIN_VALUE;
        for (Short value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Short>(min, max);
    }

    public static MinMaxValue<Integer> minMaxInteger(Collection<Integer> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Integer min = Integer.MAX_VALUE;
        Integer max = Integer.MIN_VALUE;
        for (Integer value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Integer>(min, max);
    }

    public static MinMaxValue<Long> minMaxLong(Collection<Long> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Long min = Long.MAX_VALUE;
        Long max = Long.MIN_VALUE;
        for (Long value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Long>(min, max);
    }

    public static MinMaxValue<Float> minMaxFloat(Collection<Float> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Float min = Float.valueOf(Float.MAX_VALUE);
        Float max = Float.valueOf(Float.MIN_VALUE);
        for (Float value : values) {
            if (value.floatValue() < min.floatValue()) {
                min = value;
            }
            if (!(value.floatValue() > max.floatValue())) continue;
            max = value;
        }
        return new MinMaxValue<Float>(min, max);
    }

    public static MinMaxValue<Double> minMaxDouble(Collection<Double> values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Double min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        for (Double value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return new MinMaxValue<Double>(min, max);
    }

    public static MinMaxValue<Byte> minMaxByte(Byte ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Byte min = 127;
        Byte max = -128;
        for (Byte value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Byte>(min, max);
    }

    public static MinMaxValue<Short> minMaxShort(Short ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Short min = Short.MAX_VALUE;
        Short max = Short.MIN_VALUE;
        for (Short value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Short>(min, max);
    }

    public static MinMaxValue<Integer> minMaxInteger(Integer ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Integer min = Integer.MAX_VALUE;
        Integer max = Integer.MIN_VALUE;
        for (Integer value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Integer>(min, max);
    }

    public static MinMaxValue<Long> minMaxLong(Long ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Long min = Long.MAX_VALUE;
        Long max = Long.MIN_VALUE;
        for (Long value : values) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new MinMaxValue<Long>(min, max);
    }

    public static MinMaxValue<Float> minMaxFloat(Float ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Float min = Float.valueOf(Float.MAX_VALUE);
        Float max = Float.valueOf(Float.MIN_VALUE);
        for (Float value : values) {
            if (value.floatValue() < min.floatValue()) {
                min = value;
            }
            if (!(value.floatValue() > max.floatValue())) continue;
            max = value;
        }
        return new MinMaxValue<Float>(min, max);
    }

    public static MinMaxValue<Double> minMaxDouble(Double ... values) {
        if (values == null) {
            throw new InvalidArgumentException("Collection cannot be null");
        }
        Double min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        for (Double value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return new MinMaxValue<Double>(min, max);
    }

    public static Collection<Double> normalizeByte(Collection<Byte> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Byte> minMaxByte = Maths.minMaxByte(values);
        for (Byte value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeShort(Collection<Short> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Short> minMaxByte = Maths.minMaxShort(values);
        for (Short value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeInt(Collection<Integer> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Integer> minMaxByte = Maths.minMaxInteger(values);
        for (Integer value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeLong(Collection<Long> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Long> minMaxByte = Maths.minMaxLong(values);
        for (Long value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeFloat(Collection<Float> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Float> minMaxByte = Maths.minMaxFloat(values);
        for (Float value : values) {
            result.add(Maths.normalize(value.floatValue(), minMaxByte.getMin().floatValue(), minMaxByte.getMax().floatValue()));
        }
        return result;
    }

    public static Collection<Double> normalizeDouble(Collection<Double> values) {
        Object result = Collections.createNewInstanceOfCollection(values.getClass());
        MinMaxValue<Double> minMaxByte = Maths.minMaxDouble(values);
        for (Double value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeByte(Byte ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Byte> minMaxByte = Maths.minMaxByte(values);
        for (Byte value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeShort(Short ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Short> minMaxByte = Maths.minMaxShort(values);
        for (Short value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeInt(Integer ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Integer> minMaxByte = Maths.minMaxInteger(values);
        for (Integer value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeLong(Long ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Long> minMaxByte = Maths.minMaxLong(values);
        for (Long value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static Collection<Double> normalizeFloat(Float ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Float> minMaxByte = Maths.minMaxFloat(values);
        for (Float value : values) {
            result.add(Maths.normalize(value.floatValue(), minMaxByte.getMin().floatValue(), minMaxByte.getMax().floatValue()));
        }
        return result;
    }

    public static List<Double> normalizeDouble(Double ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        MinMaxValue<Double> minMaxByte = Maths.minMaxDouble(values);
        for (Double value : values) {
            result.add(Maths.normalize(value, minMaxByte.getMin(), minMaxByte.getMax()));
        }
        return result;
    }

    public static byte adjustToRange(byte value, byte min, byte max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static short adjustToRange(short value, short min, short max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static int adjustToRange(int value, int min, int max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static long adjustToRange(long value, long min, long max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static float adjustToRange(float value, float min, float max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static double adjustToRange(double value, double min, double max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (value > max) {
            return max;
        }
        return min;
    }

    public static double averageByte(Collection<Byte> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Byte b : values) {
            sum += (double)b.byteValue();
        }
        return sum / (double)values.size();
    }

    public static double averageShort(Collection<Short> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Short b : values) {
            sum += (double)b.shortValue();
        }
        return sum / (double)values.size();
    }

    public static double averageInteger(Collection<Integer> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Integer b : values) {
            sum += (double)b.intValue();
        }
        return sum / (double)values.size();
    }

    public static double averageLong(Collection<Long> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Long b : values) {
            sum += (double)b.longValue();
        }
        return sum / (double)values.size();
    }

    public static double averageFloat(Collection<Float> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Float b : values) {
            sum += (double)b.floatValue();
        }
        return sum / (double)values.size();
    }

    public static double averageDouble(Collection<Double> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double sum = 0.0;
        for (Double b : values) {
            sum += b.doubleValue();
        }
        return sum / (double)values.size();
    }

    public static double averageByte(Byte ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Byte b : values) {
            sum += (double)b.byteValue();
        }
        return sum / (double)values.length;
    }

    public static double averageShort(Short ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Short b : values) {
            sum += (double)b.shortValue();
        }
        return sum / (double)values.length;
    }

    public static double averageInteger(Integer ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Integer b : values) {
            sum += (double)b.intValue();
        }
        return sum / (double)values.length;
    }

    public static double averageLong(Long ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Long b : values) {
            sum += (double)b.longValue();
        }
        return sum / (double)values.length;
    }

    public static double averageFloat(Float ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Float b : values) {
            sum += (double)b.floatValue();
        }
        return sum / (double)values.length;
    }

    public static double averageDouble(Double ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double sum = 0.0;
        for (Double b : values) {
            sum += b.doubleValue();
        }
        return sum / (double)values.length;
    }

    public static double varianceByte(Collection<Byte> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageByte(values);
        double t = 0.0;
        for (Byte value : values) {
            t += Math.pow((double)value.byteValue() - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceShort(Collection<Short> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageShort(values);
        double t = 0.0;
        for (Short value : values) {
            t += Math.pow((double)value.shortValue() - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceInteger(Collection<Integer> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageInteger(values);
        double t = 0.0;
        for (Integer value : values) {
            t += Math.pow((double)value.intValue() - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceLong(Collection<Long> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageLong(values);
        double t = 0.0;
        for (Long value : values) {
            t += Math.pow((double)value.longValue() - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceFloat(Collection<Float> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageFloat(values);
        double t = 0.0;
        for (Float value : values) {
            t += Math.pow((double)value.floatValue() - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceDouble(Collection<Double> values) {
        if (values == null || values.size() == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageDouble(values);
        double t = 0.0;
        for (Double value : values) {
            t += Math.pow(value - avg, 2.0);
        }
        return t / (double)values.size();
    }

    public static double varianceByte(Byte ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double avg = Maths.averageByte(values);
        double t = 0.0;
        for (Byte value : values) {
            t += Math.pow((double)value.byteValue() - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double varianceShort(Short ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double avg = Maths.averageShort(values);
        double t = 0.0;
        for (Short value : values) {
            t += Math.pow((double)value.shortValue() - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double varianceInteger(Integer ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double avg = Maths.averageInteger(values);
        double t = 0.0;
        for (Integer value : values) {
            t += Math.pow((double)value.intValue() - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double varianceLong(Long ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Collection cannot be null or empty");
        }
        double avg = Maths.averageLong(values);
        double t = 0.0;
        for (Long value : values) {
            t += Math.pow((double)value.longValue() - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double varianceFloat(Float ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double avg = Maths.averageFloat(values);
        double t = 0.0;
        for (Float value : values) {
            t += Math.pow((double)value.floatValue() - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double varianceDouble(Double ... values) {
        if (values == null || values.length == 0) {
            throw new InvalidArgumentException("Array cannot be null or empty");
        }
        double avg = Maths.averageDouble(values);
        double t = 0.0;
        for (Double value : values) {
            t += Math.pow(value - avg, 2.0);
        }
        return t / (double)values.length;
    }

    public static double standardDeviationByte(Collection<Byte> values) {
        return Math.sqrt(Maths.varianceByte(values));
    }

    public static double standardDeviationShort(Collection<Short> values) {
        return Math.sqrt(Maths.varianceShort(values));
    }

    public static double standardDeviationInteger(Collection<Integer> values) {
        return Math.sqrt(Maths.varianceInteger(values));
    }

    public static double standardDeviationLong(Collection<Long> values) {
        return Math.sqrt(Maths.varianceLong(values));
    }

    public static double standardDeviationFloat(Collection<Float> values) {
        return Math.sqrt(Maths.varianceFloat(values));
    }

    public static double standardDeviationDouble(Collection<Double> values) {
        return Math.sqrt(Maths.varianceDouble(values));
    }

    public static double standardDeviationByte(Byte ... values) {
        return Math.sqrt(Maths.varianceByte(values));
    }

    public static double standardDeviationShort(Short ... values) {
        return Math.sqrt(Maths.varianceShort(values));
    }

    public static double standardDeviationInteger(Integer ... values) {
        return Math.sqrt(Maths.varianceInteger(values));
    }

    public static double standardDeviationLong(Long ... values) {
        return Math.sqrt(Maths.varianceLong(values));
    }

    public static double standardDeviationFloat(Float ... values) {
        return Math.sqrt(Maths.varianceFloat(values));
    }

    public static double standardDeviationDouble(Double ... values) {
        return Math.sqrt(Maths.varianceDouble(values));
    }
}

