/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.tests.assertion;

public final class ExceptionAssert {
    private final Throwable throwable;

    ExceptionAssert(Throwable throwable) {
        this.throwable = throwable;
    }

    public ExceptionAssert isNotThrown() {
        if (this.throwable == null) {
            return this;
        }
        throw new AssertionError((Object)"Expected exception NOT to be thrown.");
    }

    public ExceptionAssert isThrown() {
        if (this.throwable != null) {
            return this;
        }
        throw new AssertionError((Object)"Expected exception to be thrown.");
    }

    public ExceptionAssert withMessage(String exceptionMessage) {
        if (this.throwable == null || this.throwable.getMessage().equals(exceptionMessage)) {
            return this;
        }
        throw new AssertionError((Object)("Expected exception message [" + exceptionMessage + "] but was [" + this.throwable.getMessage() + "]."));
    }

    public ExceptionAssert withMessage(String format, Object ... objects) {
        return this.withMessage(String.format(format, objects));
    }

    public ExceptionAssert withMessageContaining(String message) {
        if (this.throwable == null || this.throwable.getMessage().contains(message)) {
            return this;
        }
        throw new AssertionError((Object)("Expected exception message [" + this.throwable.getMessage() + "] to contain [" + message + "]"));
    }

    public ExceptionAssert as(String string) {
        return this;
    }
}

