/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.sweetener.text;

import java.util.Map;
import pl.jsolve.sweetener.collection.Maps;
import pl.jsolve.sweetener.exception.InvalidArgumentException;

public class Escapes {
    private static final Map<Character, String> regexpSpecials = Maps.newHashMap();
    private static final Map<Character, String> htmlSpecials = Maps.newHashMap();
    private static final Map<Character, String> urlSpecials = Maps.newHashMap();
    private static final Map<Character, String> xmlSpecials = Maps.newHashMap();
    private static final Map<Character, String> jsonSpecials = Maps.newHashMap();

    private static void regexpSpecial() {
        regexpSpecials.put(Character.valueOf('.'), "\\.");
        regexpSpecials.put(Character.valueOf('\\'), "\\\\");
        regexpSpecials.put(Character.valueOf('?'), "\\?");
        regexpSpecials.put(Character.valueOf('*'), "\\*");
        regexpSpecials.put(Character.valueOf('+'), "\\+");
        regexpSpecials.put(Character.valueOf('&'), "\\&");
        regexpSpecials.put(Character.valueOf(':'), "\\:");
        regexpSpecials.put(Character.valueOf('{'), "\\{");
        regexpSpecials.put(Character.valueOf('}'), "\\}");
        regexpSpecials.put(Character.valueOf('['), "\\[");
        regexpSpecials.put(Character.valueOf(']'), "\\]");
        regexpSpecials.put(Character.valueOf('('), "\\(");
        regexpSpecials.put(Character.valueOf(')'), "\\)");
        regexpSpecials.put(Character.valueOf('^'), "\\^");
        regexpSpecials.put(Character.valueOf('$'), "\\$");
    }

    private static void htmlSpecial() {
        htmlSpecials.put(Character.valueOf('<'), "&lt;");
        htmlSpecials.put(Character.valueOf('>'), "&gt;");
        htmlSpecials.put(Character.valueOf('&'), "&amp;");
        htmlSpecials.put(Character.valueOf('\"'), "&quot;");
        htmlSpecials.put(Character.valueOf('\t'), "&#009;");
        htmlSpecials.put(Character.valueOf('!'), "&#033;");
        htmlSpecials.put(Character.valueOf('#'), "&#035;");
        htmlSpecials.put(Character.valueOf('$'), "&#036;");
        htmlSpecials.put(Character.valueOf('%'), "&#037;");
        htmlSpecials.put(Character.valueOf('\''), "&#039;");
        htmlSpecials.put(Character.valueOf('('), "&#040;");
        htmlSpecials.put(Character.valueOf(')'), "&#041;");
        htmlSpecials.put(Character.valueOf('*'), "&#042;");
        htmlSpecials.put(Character.valueOf('+'), "&#043;");
        htmlSpecials.put(Character.valueOf(','), "&#044;");
        htmlSpecials.put(Character.valueOf('-'), "&#045;");
        htmlSpecials.put(Character.valueOf('.'), "&#046;");
        htmlSpecials.put(Character.valueOf('/'), "&#047;");
        htmlSpecials.put(Character.valueOf(':'), "&#058;");
        htmlSpecials.put(Character.valueOf(';'), "&#059;");
        htmlSpecials.put(Character.valueOf('='), "&#061;");
        htmlSpecials.put(Character.valueOf('?'), "&#063;");
        htmlSpecials.put(Character.valueOf('@'), "&#064;");
        htmlSpecials.put(Character.valueOf('['), "&#091;");
        htmlSpecials.put(Character.valueOf('\\'), "&#092;");
        htmlSpecials.put(Character.valueOf(']'), "&#093;");
        htmlSpecials.put(Character.valueOf('^'), "&#094;");
        htmlSpecials.put(Character.valueOf('_'), "&#095;");
        htmlSpecials.put(Character.valueOf('`'), "&#096;");
        htmlSpecials.put(Character.valueOf('{'), "&#123;");
        htmlSpecials.put(Character.valueOf('|'), "&#124;");
        htmlSpecials.put(Character.valueOf('}'), "&#125;");
        htmlSpecials.put(Character.valueOf('~'), "&#126;");
    }

    private static void urlSpecial() {
        urlSpecials.put(Character.valueOf(' '), "%20");
        urlSpecials.put(Character.valueOf('\"'), "%22");
        urlSpecials.put(Character.valueOf('<'), "%3c");
        urlSpecials.put(Character.valueOf('>'), "%3e");
        urlSpecials.put(Character.valueOf('#'), "%23");
        urlSpecials.put(Character.valueOf('%'), "%25");
        urlSpecials.put(Character.valueOf('{'), "%7b");
        urlSpecials.put(Character.valueOf('}'), "%7d");
        urlSpecials.put(Character.valueOf('|'), "%7c");
        urlSpecials.put(Character.valueOf('\\'), "%5c");
        urlSpecials.put(Character.valueOf('^'), "%5e");
        urlSpecials.put(Character.valueOf('~'), "%7e");
        urlSpecials.put(Character.valueOf('['), "%5b");
        urlSpecials.put(Character.valueOf(']'), "%5d");
        urlSpecials.put(Character.valueOf('`'), "%60");
    }

    private static void xmlSpecial() {
        xmlSpecials.put(Character.valueOf('<'), "&lt;");
        xmlSpecials.put(Character.valueOf('>'), "&gt;");
        xmlSpecials.put(Character.valueOf('\"'), "&quot;");
        xmlSpecials.put(Character.valueOf('\''), "&#039;");
        xmlSpecials.put(Character.valueOf('&'), "&amp;");
    }

    private static void jsonSpecial() {
        jsonSpecials.put(Character.valueOf('\"'), "\\\"");
        jsonSpecials.put(Character.valueOf('\\'), "\\\\");
        jsonSpecials.put(Character.valueOf('/'), "\\/");
        jsonSpecials.put(Character.valueOf('\b'), "\\b");
        jsonSpecials.put(Character.valueOf('\f'), "\\f");
        jsonSpecials.put(Character.valueOf('\n'), "\\n");
        jsonSpecials.put(Character.valueOf('\r'), "\\r");
        jsonSpecials.put(Character.valueOf('\t'), "\\t");
    }

    public static String escapeRegexp(String value) {
        return Escapes.escape(value, regexpSpecials);
    }

    public static String escapeHtml(String value) {
        return Escapes.escape(value, htmlSpecials);
    }

    public static String escapeUrl(String value) {
        return Escapes.escape(value, urlSpecials);
    }

    public static String escapeXml(String value) {
        return Escapes.escape(value, xmlSpecials);
    }

    public static String escapeJson(String value) {
        return Escapes.escape(value, jsonSpecials);
    }

    public static String escape(String value, Map<Character, String> specials) {
        if (value == null) {
            throw new InvalidArgumentException("String cannot be null");
        }
        if (specials == null) {
            throw new InvalidArgumentException("Map cannot be null");
        }
        StringBuffer sb = new StringBuffer(value);
        int countOfReplacements = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (!specials.containsKey(Character.valueOf(value.charAt(i)))) continue;
            sb.deleteCharAt(i + countOfReplacements).insert(i + countOfReplacements, specials.get(Character.valueOf(value.charAt(i))));
            countOfReplacements += specials.get(Character.valueOf(value.charAt(i))).length() - 1;
        }
        return sb.toString();
    }

    public static Map<Character, String> getRegexpspecials() {
        return Maps.newHashMap(regexpSpecials);
    }

    public static Map<Character, String> getHtmlspecials() {
        return Maps.newHashMap(htmlSpecials);
    }

    public static Map<Character, String> getUrlspecials() {
        return Maps.newHashMap(urlSpecials);
    }

    public static Map<Character, String> getXmlspecials() {
        return Maps.newHashMap(xmlSpecials);
    }

    public static Map<Character, String> getJsonspecials() {
        return Maps.newHashMap(jsonSpecials);
    }

    static {
        Escapes.regexpSpecial();
        Escapes.htmlSpecial();
        Escapes.urlSpecial();
        Escapes.xmlSpecial();
        Escapes.jsonSpecial();
    }
}

