/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.strategy;

import pl.jsolve.templ4docx.cleaner.ParagraphCleaner;
import pl.jsolve.templ4docx.cleaner.TableRowCleaner;
import pl.jsolve.templ4docx.insert.Insert;
import pl.jsolve.templ4docx.strategy.BulletListInsertStrategy;
import pl.jsolve.templ4docx.strategy.ImageInsertStrategy;
import pl.jsolve.templ4docx.strategy.TableInsertStrategy;
import pl.jsolve.templ4docx.strategy.TextInsertStrategy;
import pl.jsolve.templ4docx.variable.Variable;
import pl.jsolve.templ4docx.variable.Variables;

public class InsertStrategyChooser {
    private TextInsertStrategy textInsertStrategy = new TextInsertStrategy();
    private ImageInsertStrategy imageInsertStrategy = new ImageInsertStrategy();
    private TableInsertStrategy tableInsertStrategy;
    private BulletListInsertStrategy bulletListInsertStrategy;
    private Variables variables;

    public InsertStrategyChooser(Variables variables, TableRowCleaner tableRowCleaner, ParagraphCleaner paragraphCleaner) {
        this.tableInsertStrategy = new TableInsertStrategy(variables, this, tableRowCleaner);
        this.bulletListInsertStrategy = new BulletListInsertStrategy(this, paragraphCleaner);
        this.variables = variables;
    }

    public void replace(Insert insert, Variable variable) {
        switch (insert.getKey().getVariableType()) {
            case TEXT: {
                this.textInsertStrategy.insert(insert, variable);
                break;
            }
            case IMAGE: {
                this.imageInsertStrategy.insert(insert, variable);
                break;
            }
            case TABLE: {
                this.tableInsertStrategy.insert(insert, variable);
                break;
            }
            case BULLET_LIST: {
                this.bulletListInsertStrategy.insert(insert, variable);
            }
        }
    }

    public void replace(Insert insert) {
        this.replace(insert, this.variables.getVariable(insert.getKey()));
    }

    public void cleanUp() {
        this.tableInsertStrategy.cleanRows();
        this.bulletListInsertStrategy.cleanParagraphs();
    }
}

