/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.maciejkopec.offlinemode.annotation.OfflineMode;
import pl.maciejkopec.offlinemode.service.ResponseCaptor;

@Aspect
public class OfflineModeAspect {
    private static final Logger log = LoggerFactory.getLogger(OfflineModeAspect.class);
    private final ResponseCaptor responseCaptor;

    @Around(value="@annotation(offlineMode)")
    public Object captureOfflineCall(ProceedingJoinPoint joinPoint, OfflineMode offlineMode) throws Throwable {
        String METHOD = "captureOfflineCall(ProceedingJoinPoint, OfflineMode)";
        log.debug("Entering {}", (Object)"captureOfflineCall(ProceedingJoinPoint, OfflineMode)");
        Object value = this.responseCaptor.capture(joinPoint, offlineMode);
        log.debug("Leaving {}", (Object)"captureOfflineCall(ProceedingJoinPoint, OfflineMode)");
        return value;
    }

    public OfflineModeAspect(ResponseCaptor responseCaptor) {
        this.responseCaptor = responseCaptor;
    }
}

