/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import pl.maciejkopec.offlinemode.annotation.OfflineMode;

public class AnnotationUsageValidation
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(AnnotationUsageValidation.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        String METHOD = "postProcessAfterInitialization(Object, String)";
        log.debug("Entering {}", (Object)"postProcessAfterInitialization(Object, String)");
        Class<?> type = bean.getClass();
        Method[] methods = type.getDeclaredMethods();
        Arrays.stream(methods).map(method -> new ValidationContext((Method)method, (OfflineMode)AnnotationUtils.findAnnotation((Method)method, OfflineMode.class))).filter(context -> Objects.nonNull(context.offlineMode())).forEach(this::validateOfflineModeUsage);
        log.debug("Leaving {}", (Object)"postProcessAfterInitialization(Object, String)");
        return super.postProcessAfterInitialization(bean, beanName);
    }

    private void validateOfflineModeUsage(ValidationContext context) {
        String METHOD = "validateOfflineModeUsage(ValidationContext)";
        log.debug("Entering {}", (Object)"validateOfflineModeUsage(ValidationContext)");
        Class<?> returnType = context.method().getReturnType();
        OfflineMode offlineMode = context.offlineMode();
        if (Void.class.equals(offlineMode.keyClass()) && Map.class.isAssignableFrom(returnType)) {
            log.error("OfflineMode is misconfigured. For Map-like return types define keyClass. Only simple types are supported. Details = {} ", (Object)context);
            throw new IllegalArgumentException("Define keyClass() in OfflineMode annotation");
        }
        if (Void.class.equals(offlineMode.elementClass()) && (Collection.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType))) {
            log.error("OfflineMode is misconfigured. For Collection-like return types define elementClass. Details = {}", (Object)context);
            throw new IllegalArgumentException("Define elementClass() in OfflineMode annotation");
        }
        log.debug("Leaving {} returnType={} offlineMode={}", new Object[]{"validateOfflineModeUsage(ValidationContext)", returnType, offlineMode});
    }

    private record ValidationContext(Method method, OfflineMode offlineMode) {
    }
}

