/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;
import pl.maciejkopec.offlinemode.aspect.OfflineModeAspect;
import pl.maciejkopec.offlinemode.config.AnnotationUsageValidation;
import pl.maciejkopec.offlinemode.config.OfflineModeConfiguration;
import pl.maciejkopec.offlinemode.service.FileHandler;
import pl.maciejkopec.offlinemode.service.KeyGenerator;
import pl.maciejkopec.offlinemode.service.ResponseCaptor;

@AutoConfiguration
@EnableConfigurationProperties(value={OfflineModeConfiguration.class})
@ConditionalOnProperty(prefix="offline-mode", name={"enabled"}, havingValue="true")
public class OfflineModeAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OfflineModeAutoConfiguration.class);
    private final OfflineModeConfiguration configuration;

    @Bean
    public OfflineModeAspect offlineModeAspect(ObjectMapper objectMapper, ResourceLoader resourceLoader) {
        String METHOD = "offlineModeAspect()";
        log.debug("Entering {}", (Object)"offlineModeAspect()");
        KeyGenerator keyGenerator = new KeyGenerator();
        FileHandler fileHandler = new FileHandler(this.configuration, resourceLoader);
        ResponseCaptor responseCaptor = new ResponseCaptor(keyGenerator, fileHandler, this.configuration, objectMapper);
        OfflineModeAspect offlineModeAspect = new OfflineModeAspect(responseCaptor);
        log.debug("Leaving {}", (Object)"offlineModeAspect()");
        return offlineModeAspect;
    }

    @Bean
    public BeanPostProcessor annotationUsageValidationBean() {
        String METHOD = "annotationUsageValidationBean()";
        log.debug("Entering {}", (Object)"annotationUsageValidationBean()");
        AnnotationUsageValidation annotationUsageValidation = new AnnotationUsageValidation();
        log.debug("Leaving {}", (Object)"annotationUsageValidationBean()");
        return annotationUsageValidation;
    }

    public OfflineModeAutoConfiguration(OfflineModeConfiguration configuration) {
        this.configuration = configuration;
    }
}

