/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.DefaultValue;

@ConfigurationProperties(prefix="offline-mode")
public class OfflineModeConfiguration {
    private final boolean enabled;
    private final Mode mode;
    private final String path;

    public OfflineModeConfiguration(@DefaultValue(value={"false"}) boolean enabled, @DefaultValue(value={"SERVING"}) Mode mode, @DefaultValue(value={"offline"}) String path) {
        this.enabled = enabled;
        this.mode = mode;
        this.path = path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getPath() {
        return this.path;
    }

    public static enum Mode {
        LEARNING,
        LEARNING_SKIP_EXISTING,
        SERVING;


        public static boolean isLearningEnabled(Mode mode) {
            return LEARNING.equals((Object)mode) || LEARNING_SKIP_EXISTING.equals((Object)mode);
        }
    }
}

