/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.expression;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import pl.maciejkopec.offlinemode.expression.ExpressionRootObject;

public class ExpressionEvaluator
extends CachedExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private final ParameterNameDiscoverer paramNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<AnnotatedElementKey, Method> targetMethodCache = new ConcurrentHashMap<AnnotatedElementKey, Method>(64);

    public EvaluationContext createEvaluationContext(Object object, Class<?> targetClass, Method method, Object[] args) {
        String METHOD = "createEvaluationContext(Object, Class, Method, Object[])";
        log.debug("Entering {}", (Object)"createEvaluationContext(Object, Class, Method, Object[])");
        Method targetMethod = this.getTargetMethod(targetClass, method);
        ExpressionRootObject root = new ExpressionRootObject(object, args);
        MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)root, targetMethod, args, this.paramNameDiscoverer);
        log.debug("Leaving {}", (Object)"createEvaluationContext(Object, Class, Method, Object[])");
        return evaluationContext;
    }

    public Object key(String keyExpression, AnnotatedElementKey methodKey, EvaluationContext evalContext) {
        String METHOD = "key(String, AnnotatedElementKey, EvaluationContext)";
        log.debug("Entering {}", (Object)"key(String, AnnotatedElementKey, EvaluationContext)");
        Object key = this.getExpression(this.conditionCache, methodKey, keyExpression).getValue(evalContext);
        log.debug("Leaving {}", (Object)"key(String, AnnotatedElementKey, EvaluationContext)");
        return key;
    }

    private Method getTargetMethod(Class<?> targetClass, Method method) {
        String METHOD = "getTargetMethod(Class, Method)";
        log.debug("Entering {}", (Object)"getTargetMethod(Class, Method)");
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        Method cachedTargetMethod = this.targetMethodCache.get(methodKey);
        if (cachedTargetMethod == null) {
            Method targetMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
            this.targetMethodCache.put(methodKey, targetMethod);
            log.debug("Target method is not cached. Generated targetMethod: `{}` added to the cache.", (Object)targetMethod.getName());
            log.debug("Leaving {}", (Object)"getTargetMethod(Class, Method)");
            return targetMethod;
        }
        log.debug("Target method `{}` is cached.", (Object)cachedTargetMethod.getName());
        log.debug("Leaving {}", (Object)"getTargetMethod(Class, Method)");
        return cachedTargetMethod;
    }
}

