/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import pl.maciejkopec.offlinemode.config.OfflineModeConfiguration;

public class FileHandler {
    private static final Logger log = LoggerFactory.getLogger(FileHandler.class);
    private static final String EXTENSION = ".json";
    private final OfflineModeConfiguration configuration;
    private final ResourceLoader resourceLoader;

    public Optional<String> read(@NonNull String key) throws IOException {
        String METHOD = "read(String)";
        log.debug("Entering {}", (Object)"read(String)");
        String location = this.configuration.getPath() + "/" + key + EXTENSION;
        Resource resource = this.resourceLoader.getResource(location);
        if (!resource.exists()) {
            log.debug("Leaving {} location={}", (Object)"read(String)", (Object)location);
            return Optional.empty();
        }
        InputStream path = resource.getInputStream();
        Optional<String> file = Optional.of(StreamUtils.copyToString((InputStream)path, (Charset)Charset.defaultCharset()));
        log.debug("Leaving {} location={} ", (Object)"read(String)", (Object)location);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NonNull String key, @NonNull String serializedObject) {
        String METHOD = "write(String, String)";
        log.debug("Entering {}", (Object)"write(String, String)");
        try {
            Path path = this.resourceLoader.getResource(this.configuration.getPath()).getFile().toPath();
            Path dir = Files.createDirectories(path, new FileAttribute[0]);
            Path file = dir.resolve(key + EXTENSION);
            Files.writeString(file, (CharSequence)serializedObject, new OpenOption[0]);
            log.debug("Writing file completed. path={} dir={} file={}", new Object[]{path, dir, file});
        }
        catch (IOException e) {
            log.error("Failed to write a file in {} for key {}", new Object[]{this.configuration.getPath(), key, e});
        }
        finally {
            log.debug("Leaving {}", (Object)"write(String, String)");
        }
    }

    public FileHandler(OfflineModeConfiguration configuration, ResourceLoader resourceLoader) {
        this.configuration = configuration;
        this.resourceLoader = resourceLoader;
    }
}

