/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.service;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import pl.maciejkopec.offlinemode.annotation.OfflineMode;
import pl.maciejkopec.offlinemode.expression.ExpressionEvaluator;

public class KeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(KeyGenerator.class);
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();

    public String generate(ProceedingJoinPoint joinPoint, OfflineMode offlineMode) {
        String METHOD = "generate(ProceedingJoinPoint, OfflineMode)";
        log.debug("Entering {}", (Object)"generate(ProceedingJoinPoint, OfflineMode)");
        String key = Objects.equals(offlineMode.key(), "") ? this.argumentBasedKey(joinPoint) : this.spelBasedKey(joinPoint, offlineMode);
        log.debug("Leaving {} key={}", (Object)"generate(ProceedingJoinPoint, OfflineMode)", (Object)key);
        return key;
    }

    private String spelBasedKey(ProceedingJoinPoint joinPoint, OfflineMode offlineMode) {
        String METHOD = "spelBasedKey(ProceedingJoinPoint, OfflineMode)";
        log.debug("Entering {}", (Object)"spelBasedKey(ProceedingJoinPoint, OfflineMode)");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(joinPoint.getTarget(), targetClass, method, joinPoint.getArgs());
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        String key = this.evaluator.key(offlineMode.key(), methodKey, evaluationContext).toString();
        log.debug("Generated key: `{}` for OfflineMode: `{}`", (Object)key, (Object)offlineMode);
        log.debug("Leaving {}", (Object)"spelBasedKey(ProceedingJoinPoint, OfflineMode)");
        return key;
    }

    private String argumentBasedKey(ProceedingJoinPoint joinPoint) {
        String METHOD = "argumentBasedKey(ProceedingJoinPoint)";
        log.debug("Entering {}", (Object)"argumentBasedKey(ProceedingJoinPoint)");
        String arguments = Arrays.stream(joinPoint.getArgs()).map(this::generateArgument).collect(Collectors.joining("~"));
        String key = String.format("%s_%s_%s", joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), arguments);
        log.debug("Generated key: `{}`", (Object)key);
        log.debug("Leaving {}", (Object)"argumentBasedKey(ProceedingJoinPoint)");
        return key;
    }

    private String generateArgument(Object argument) {
        if (BeanUtils.isSimpleProperty(argument.getClass())) {
            return argument.toString();
        }
        return String.valueOf(Objects.hashCode(argument));
    }
}

