/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejkopec.offlinemode.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.maciejkopec.offlinemode.annotation.OfflineMode;
import pl.maciejkopec.offlinemode.config.OfflineModeConfiguration;
import pl.maciejkopec.offlinemode.service.FileHandler;
import pl.maciejkopec.offlinemode.service.KeyGenerator;

public class ResponseCaptor {
    private static final Logger log = LoggerFactory.getLogger(ResponseCaptor.class);
    private final KeyGenerator keyGenerator;
    private final FileHandler fileHandler;
    private final OfflineModeConfiguration configuration;
    private final ObjectMapper objectMapper;

    public Object capture(ProceedingJoinPoint joinPoint, OfflineMode offlineMode) throws Throwable {
        String METHOD = "capture(ProceedingJoinPoint, OfflineMode)";
        log.debug("Entering {}", (Object)"capture(ProceedingJoinPoint, OfflineMode)");
        String key = this.keyGenerator.generate(joinPoint, offlineMode);
        Signature signature = joinPoint.getSignature();
        Class returnType = ((MethodSignature)signature).getReturnType();
        Optional<String> jsonFile = this.fileHandler.read(key);
        if (OfflineModeConfiguration.Mode.isLearningEnabled(this.configuration.getMode())) {
            if (OfflineModeConfiguration.Mode.LEARNING_SKIP_EXISTING.equals((Object)this.configuration.getMode()) && jsonFile.isPresent()) {
                Class<?> clazz = offlineMode.elementClass();
                JavaType valueType = this.resolveReturnType(offlineMode, returnType, clazz);
                Object value = this.objectMapper.readValue(jsonFile.get(), valueType);
                log.debug("Read existing file for key = {}", (Object)key);
                log.debug("Leaving {}", (Object)"capture(ProceedingJoinPoint, OfflineMode)");
                return value;
            }
            Object object = joinPoint.proceed();
            String serializedObject = this.objectMapper.writeValueAsString(object);
            this.fileHandler.write(key, serializedObject);
            log.debug("Generated file for key = {}", (Object)key);
            log.debug("Leaving {}", (Object)"capture(ProceedingJoinPoint, OfflineMode)");
            return object;
        }
        if (jsonFile.isPresent()) {
            Class<?> clazz = offlineMode.elementClass();
            JavaType valueType = this.resolveReturnType(offlineMode, returnType, clazz);
            Object value = this.objectMapper.readValue(jsonFile.get(), valueType);
            log.debug("Leaving {}", (Object)"capture(ProceedingJoinPoint, OfflineMode)");
            return value;
        }
        log.warn("No captured data found for '{}' in {}, calling actual method. Switch to '{}' mode to generate offline file.", new Object[]{key, this.configuration.getPath(), OfflineModeConfiguration.Mode.LEARNING});
        Object proceed = joinPoint.proceed();
        log.debug("Leaving {}", (Object)"capture(ProceedingJoinPoint, OfflineMode)");
        return proceed;
    }

    private JavaType resolveReturnType(OfflineMode offlineMode, Class<?> returnType, Class<?> clazz) {
        String METHOD = "resolveReturnType(OfflineMode, Class, Class<?>)";
        log.debug("Entering {}", (Object)"resolveReturnType(OfflineMode, Class, Class<?>)");
        Object type = Map.class.isAssignableFrom(returnType) ? this.objectMapper.getTypeFactory().constructMapType(returnType, offlineMode.keyClass(), clazz) : (Collection.class.isAssignableFrom(returnType) ? this.objectMapper.getTypeFactory().constructCollectionType(returnType, clazz) : (returnType.isArray() ? this.objectMapper.getTypeFactory().constructArrayType(clazz) : this.objectMapper.getTypeFactory().constructType(returnType)));
        log.debug("Leaving {}, type={}", (Object)"resolveReturnType(OfflineMode, Class, Class<?>)", type);
        return type;
    }

    public ResponseCaptor(KeyGenerator keyGenerator, FileHandler fileHandler, OfflineModeConfiguration configuration, ObjectMapper objectMapper) {
        this.keyGenerator = keyGenerator;
        this.fileHandler = fileHandler;
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }
}

