/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api;

import java.io.IOException;
import pl.pojo.tester.api.PackageFilter;
import pl.pojo.tester.api.PackageFilterException;
import pl.pojo.tester.internal.preconditions.ParameterPreconditions;
import pl.pojo.tester.internal.utils.ReflectionUtils;

public final class DefaultPackageFilter
implements PackageFilter {
    private final String packageName;

    private DefaultPackageFilter(String packageName) {
        ParameterPreconditions.checkNotBlank("packageName", packageName);
        this.packageName = packageName;
    }

    public static DefaultPackageFilter forPackage(String packageName) {
        return new DefaultPackageFilter(packageName);
    }

    public static DefaultPackageFilter forClass(Class<?> clazz) {
        return new DefaultPackageFilter(clazz.getPackage().getName());
    }

    @Override
    public Class<?>[] getClasses() {
        try {
            return ReflectionUtils.getClassesFromPackage(this.packageName);
        }
        catch (IOException e) {
            throw new PackageFilterException(this.packageName, e);
        }
    }
}

