/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api.assertion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.slf4j.Logger;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.api.assertion.Method;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.preconditions.ParameterPreconditions;
import pl.pojo.tester.internal.tester.AbstractTester;
import pl.pojo.tester.internal.utils.ClassLoader;
import pl.pojo.tester.internal.utils.Permutator;
import pl.pojo.tester.internal.utils.SublistFieldPermutator;
import pl.pojo.tester.internal.utils.ThoroughFieldPermutator;

public abstract class AbstractAssertion {
    private static final Set<AbstractTester> DEFAULT_TESTERS = new HashSet<AbstractTester>();
    private final MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters = new ArrayListValuedHashMap();
    Set<AbstractTester> testers = new HashSet<AbstractTester>();
    private AbstractFieldValueChanger abstractFieldValueChanger;
    private Permutator permutator = new ThoroughFieldPermutator();

    public AbstractAssertion using(AbstractFieldValueChanger abstractFieldValueChanger) {
        ParameterPreconditions.checkNotNull("abstractFieldValueChanger", abstractFieldValueChanger);
        this.abstractFieldValueChanger = abstractFieldValueChanger;
        return this;
    }

    public AbstractAssertion thoroughly() {
        this.permutator = new ThoroughFieldPermutator();
        return this;
    }

    public AbstractAssertion quickly() {
        this.permutator = new SublistFieldPermutator();
        return this;
    }

    public AbstractAssertion testing(Method ... methods) {
        ParameterPreconditions.checkNotNull("methods", (Object[])methods);
        Arrays.asList(methods).forEach(this::testing);
        return this;
    }

    public AbstractAssertion testing(Method method) {
        ParameterPreconditions.checkNotNull("method", (Object)method);
        AbstractTester tester = method.getTester();
        this.testers.add(tester);
        return this;
    }

    public void areWellImplemented() {
        if (this.testers.isEmpty()) {
            this.testers = DEFAULT_TESTERS;
        }
        if (this.abstractFieldValueChanger != null) {
            this.testers.forEach(tester -> tester.setFieldValuesChanger(this.abstractFieldValueChanger));
        }
        this.testers.forEach(tester -> tester.setPermutator(this.permutator));
        this.testers.forEach(tester -> tester.setUserDefinedConstructors(this.constructorParameters));
        this.runAssertions();
    }

    public AbstractAssertion create(String qualifiedClassName, Object[] constructorParameters, Class<?>[] constructorParameterTypes) {
        ParameterPreconditions.checkNotBlank("qualifiedClassName", qualifiedClassName);
        ConstructorParameters constructorParameter = new ConstructorParameters(constructorParameters, constructorParameterTypes);
        return this.create(qualifiedClassName, constructorParameter);
    }

    public AbstractAssertion create(String qualifiedClassName, ConstructorParameters constructorParameters) {
        ParameterPreconditions.checkNotBlank("qualifiedClassName", qualifiedClassName);
        ParameterPreconditions.checkNotNull("constructorParameters", constructorParameters);
        Class<?> clazz = ClassLoader.loadClass(qualifiedClassName);
        this.constructorParameters.put(clazz, (Object)constructorParameters);
        return this;
    }

    public AbstractAssertion create(Class<?> clazz, Object[] constructorParameters, Class<?>[] constructorParameterTypes) {
        ParameterPreconditions.checkNotNull("clazz", clazz);
        ConstructorParameters constructorParameter = new ConstructorParameters(constructorParameters, constructorParameterTypes);
        return this.create(clazz, constructorParameter);
    }

    public AbstractAssertion create(Class<?> clazz, ConstructorParameters constructorParameters) {
        ParameterPreconditions.checkNotNull("clazz", clazz);
        ParameterPreconditions.checkNotNull("constructorParameters", constructorParameters);
        this.constructorParameters.put(clazz, (Object)constructorParameters);
        return this;
    }

    protected abstract void runAssertions();

    protected void logTestersAndClasses(Logger logger, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        if (logger.isDebugEnabled()) {
            String classes = Arrays.stream(classAndFieldPredicatePairs).map(ClassAndFieldPredicatePair::toString).collect(Collectors.joining(", ", "[", "]"));
            logger.debug("Running {} testers on {} classes", (Object)this.testers.size(), (Object)classAndFieldPredicatePairs.length);
            logger.debug("Testers: {}", this.testers);
            logger.debug("Classes: {}", (Object)classes);
        }
    }

    static {
        Arrays.stream(Method.values()).map(Method::getTester).forEach(DEFAULT_TESTERS::add);
    }
}

