/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.equals;

import pl.pojo.tester.internal.assertion.equals.AbstractEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.ConsistentEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.EqualEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.NotEqualEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.NullEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.OtherTypeEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.ReflexiveEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.SymmetricEqualsAssertionError;
import pl.pojo.tester.internal.assertion.equals.TransitiveEqualsAssertionError;

public class EqualAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public EqualAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void isReflexive() {
        boolean result = this.objectUnderAssert.equals(this.objectUnderAssert);
        this.checkResult(result, new ReflexiveEqualsAssertionError(this.classUnderTest, this.objectUnderAssert));
    }

    public void isConsistent() {
        boolean result1 = this.objectUnderAssert.equals(this.objectUnderAssert);
        boolean result2 = this.objectUnderAssert.equals(this.objectUnderAssert);
        boolean result = result1 && result2;
        this.checkResult(result, new ConsistentEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, result1, result2));
    }

    public void isSymmetric(Object otherObject) {
        boolean result2;
        boolean result1 = this.objectUnderAssert.equals(otherObject);
        boolean result = result1 == (result2 = otherObject.equals(this.objectUnderAssert));
        this.checkResult(result, new SymmetricEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, otherObject, result1, result2));
    }

    public void isTransitive(Object b, Object c) {
        boolean result1 = this.objectUnderAssert.equals(b);
        boolean result2 = b.equals(c);
        boolean result3 = this.objectUnderAssert.equals(c);
        boolean partialResult1 = result1 == result2;
        boolean partialResult2 = result2 == result3;
        boolean result = partialResult1 && partialResult2;
        this.checkResult(result, new TransitiveEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, b, c, result1, result2, result3));
    }

    public void isNotEqualToNull() {
        boolean result = !this.objectUnderAssert.equals(null);
        this.checkResult(result, new NullEqualsAssertionError(this.classUnderTest));
    }

    public void isNotEqualToObjectWithDifferentType(Object otherObject) {
        boolean result = !this.objectUnderAssert.equals(otherObject);
        this.checkResult(result, new OtherTypeEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, otherObject));
    }

    public void isNotEqualTo(Object objectToCompare) {
        boolean result = !this.objectUnderAssert.equals(objectToCompare);
        this.checkResult(result, new NotEqualEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, objectToCompare));
    }

    public void isEqualTo(Object objectToCompare) {
        boolean result = this.objectUnderAssert.equals(objectToCompare);
        this.checkResult(result, new EqualEqualsAssertionError(this.classUnderTest, this.objectUnderAssert, objectToCompare));
    }

    private void checkResult(boolean pass, AbstractEqualsAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

