/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.getter;

import java.lang.reflect.Field;
import pl.pojo.tester.internal.assertion.AbstractAssertionError;

class GetterAssertionError
extends AbstractAssertionError {
    private static final String CONSTRAINT_GETTER = "The getter method for field '%s' should return field value.\nCurrent implementation returns different value.\nExpected value:\n%s\nbut was:\n%s";
    private final Field field;
    private final Object expectedValue;
    private final Object currentValue;

    GetterAssertionError(Class<?> testedCass, Field field, Object expectedValue, Object currentValue) {
        super(testedCass);
        this.field = field;
        this.expectedValue = expectedValue;
        this.currentValue = currentValue;
    }

    @Override
    protected String getDetailedMessage() {
        return String.format(CONSTRAINT_GETTER, this.field, this.expectedValue, this.currentValue);
    }

    @Override
    protected String getErrorPrefix() {
        return String.format("Class %s has bad 'getter' method implementation.", this.testedCass.getCanonicalName());
    }
}

