/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections4.MultiValuedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractMultiConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class BestConstructorInstantiator
extends AbstractMultiConstructorInstantiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BestConstructorInstantiator.class);

    BestConstructorInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz, constructorParameters);
    }

    @Override
    public Object instantiate() {
        Object result = this.instantiateUsingUserParameters();
        if (result == null) {
            result = this.createFindingBestConstructor();
        }
        return result;
    }

    @Override
    public boolean canInstantiate() {
        return true;
    }

    @Override
    protected ObjectInstantiationException createObjectInstantiationException() {
        return new ObjectInstantiationException(this.clazz, "Class could not be created by any constructor (using BestConstructorInstantiator).");
    }

    @Override
    protected Object createObjectFromArgsConstructor(Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Constructor declaredConstructor = this.clazz.getDeclaredConstructor(parameterTypes);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(parameters);
        }
        catch (ReflectiveOperationException e) {
            throw new ObjectInstantiationException(this.clazz, "Could not create object from args constructor", parameterTypes, parameters, e);
        }
    }

    @Override
    protected Object createObjectFromNoArgsConstructor(Constructor<?> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.debug("Exception:", (Throwable)e);
            return null;
        }
    }
}

