/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class DefaultConstructorInstantiator
extends AbstractObjectInstantiator {
    DefaultConstructorInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz, constructorParameters);
    }

    @Override
    public Object instantiate() {
        try {
            Constructor defaultConstructor = this.clazz.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ObjectInstantiationException(this.clazz, e.getMessage(), e);
        }
    }

    @Override
    public boolean canInstantiate() {
        Constructor<?>[] constructors = this.clazz.getConstructors();
        return !this.qualifiesForProxy(this.clazz) && Arrays.stream(constructors).filter(this::isNoArgs).anyMatch(this::isPublic);
    }

    private boolean qualifiesForProxy(Class<?> clazz) {
        return clazz.isInterface() || clazz.isAnnotation() || Modifier.isAbstract(clazz.getModifiers());
    }

    private boolean isPublic(Constructor<?> constructor) {
        return (constructor.getModifiers() & 1) != 0;
    }

    private boolean isNoArgs(Constructor<?> constructor) {
        return constructor.getParameterCount() == 0;
    }
}

