/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.commons.collections4.MultiValuedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractMultiConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.BestConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class ProxyInstantiator
extends AbstractMultiConstructorInstantiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BestConstructorInstantiator.class);
    private final ProxyFactory proxyFactory = new ProxyFactory();

    ProxyInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz, constructorParameters);
    }

    @Override
    public Object instantiate() {
        Object result = this.instantiateUsingUserParameters();
        if (result == null) {
            if (this.clazz.isAnnotation() || this.clazz.isInterface()) {
                result = this.proxyByJava();
            } else {
                this.proxyFactory.setSuperclass(this.clazz);
                result = this.createFindingBestConstructor();
            }
        }
        return result;
    }

    @Override
    public boolean canInstantiate() {
        return this.qualifiesForProxy(this.clazz);
    }

    private boolean qualifiesForProxy(Class<?> clazz) {
        return clazz.isInterface() || clazz.isAnnotation() || Modifier.isAbstract(clazz.getModifiers());
    }

    private Object proxyByJava() {
        return Proxy.newProxyInstance(this.clazz.getClassLoader(), new Class[]{this.clazz}, this::createInvocationHandler);
    }

    @Override
    protected Object createObjectFromArgsConstructor(Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Class proxyClass = this.proxyFactory.createClass();
            Constructor declaredConstructor = proxyClass.getDeclaredConstructor(parameterTypes);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(parameters);
        }
        catch (ReflectiveOperationException e) {
            throw new ObjectInstantiationException(this.clazz, "Could not create object from args constructor", e);
        }
    }

    @Override
    protected Object createObjectFromNoArgsConstructor(Constructor<?> constructor) {
        try {
            return this.proxyFactory.create(new Class[0], (Object[])new Class[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.debug("Exception:", (Throwable)e);
            return null;
        }
    }

    private Object createInvocationHandler(Object proxy, Method method, Object[] args) {
        try {
            method.setAccessible(true);
            return method.invoke(proxy, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.debug("Exception:", (Throwable)e);
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class)) {
                return true;
            }
            if (returnType.equals(String.class)) {
                return "string";
            }
            return 0;
        }
    }

    @Override
    protected ObjectInstantiationException createObjectInstantiationException() {
        return new ObjectInstantiationException(this.clazz, "Class could not be created by any constructor (using ProxyInstantiator).");
    }
}

