/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;

public class HashCodeTester
extends AbstractTester {
    public HashCodeTester() {
    }

    public HashCodeTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        Object instance = this.objectGenerator.createNewInstance(testedClass);
        this.shouldHaveSameHashCodes(instance);
        this.shouldHaveSameHashCodesWithDifferentInstance(instance);
        this.shouldHaveDifferentHashCodesForUserDefinedFields(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
        this.shouldHaveSameHashCodesForInversionOfUserDefinedFields(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
    }

    private void shouldHaveSameHashCodes(Object object) {
        this.testAssertions.assertThatHashCodeMethodFor(object).isConsistent();
    }

    private void shouldHaveSameHashCodesWithDifferentInstance(Object object) {
        Object otherObject = this.objectGenerator.generateSameInstance(object);
        this.testAssertions.assertThatHashCodeMethodFor(object).returnsSameValueFor(otherObject);
    }

    private void shouldHaveDifferentHashCodesForUserDefinedFields(ClassAndFieldPredicatePair base, ClassAndFieldPredicatePair ... nested) {
        List<Object> differentObjects = this.objectGenerator.generateDifferentObjects(base, nested);
        Object firstObject = differentObjects.remove(0);
        differentObjects.forEach(this.assertHaveDifferentHashCodes(firstObject));
    }

    private Consumer<Object> assertHaveDifferentHashCodes(Object object) {
        return eachDifferentObject -> this.testAssertions.assertThatHashCodeMethodFor(object).returnsDifferentValueFor(eachDifferentObject);
    }

    private void shouldHaveSameHashCodesForInversionOfUserDefinedFields(ClassAndFieldPredicatePair base, ClassAndFieldPredicatePair ... nested) {
        ClassAndFieldPredicatePair baseWithInvertedFields = this.invertIncludedFields(base);
        List<Object> differentObjects = this.objectGenerator.generateDifferentObjects(baseWithInvertedFields, nested);
        Object firstObject = differentObjects.remove(0);
        differentObjects.forEach(this.assertHaveSameHashCodes(firstObject));
    }

    private ClassAndFieldPredicatePair invertIncludedFields(ClassAndFieldPredicatePair base) {
        Class<?> clazz = base.getClazz();
        Predicate<String> excludedFields = base.getFieldsPredicate().negate();
        return new ClassAndFieldPredicatePair(clazz, excludedFields);
    }

    private Consumer<Object> assertHaveSameHashCodes(Object object) {
        return eachDifferentObject -> this.testAssertions.assertThatHashCodeMethodFor(object).returnsSameValueFor(eachDifferentObject);
    }
}

