/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;
import pl.pojo.tester.internal.utils.FieldUtils;

public class ToStringTester
extends AbstractTester {
    public ToStringTester() {
    }

    public ToStringTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        Object instance = this.objectGenerator.createNewInstance(testedClass);
        List<Field> includedFields = this.getIncludedFields(baseClassAndFieldPredicatePair);
        this.shouldContainValues(instance, includedFields);
        List<Field> excludedFields = this.getExcludedFields(baseClassAndFieldPredicatePair);
        this.shouldNotContainValues(instance, excludedFields);
    }

    private List<Field> getIncludedFields(ClassAndFieldPredicatePair classAndFieldPredicatePair) {
        Class<?> testedClass = classAndFieldPredicatePair.getClazz();
        return FieldUtils.getFields(testedClass, classAndFieldPredicatePair.getFieldsPredicate());
    }

    private List<Field> getExcludedFields(ClassAndFieldPredicatePair classAndFieldPredicatePair) {
        List<Field> includedFields = this.getIncludedFields(classAndFieldPredicatePair);
        List<String> included = includedFields.stream().map(Field::getName).collect(Collectors.toList());
        return FieldUtils.getAllFieldsExcluding(classAndFieldPredicatePair.getClazz(), included);
    }

    private void shouldContainValues(Object instance, List<Field> fields) {
        fields.forEach(this.assertThatToStringContainsValue(instance));
    }

    private void shouldNotContainValues(Object instance, List<Field> fields) {
        fields.forEach(this.assertThatToStringDoesNotContainValue(instance));
    }

    private Consumer<Field> assertThatToStringContainsValue(Object instance) {
        return field -> {
            String fieldName = field.getName();
            Object value = FieldUtils.getValue(instance, field);
            this.testAssertions.assertThatToStringMethodFor(instance).contains(fieldName, value);
        };
    }

    private Consumer<Field> assertThatToStringDoesNotContainValue(Object instance) {
        return field -> {
            String fieldName = field.getName();
            Object value = FieldUtils.getValue(instance, field);
            this.testAssertions.assertThatToStringMethodFor(instance).doestNotContain(fieldName, value);
        };
    }
}

