/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import pl.pojo.tester.api.PackageFilterException;
import pl.pojo.tester.internal.utils.ClassLoader;

public final class ReflectionUtils {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String FILE_SEPARATOR = "/";
    private static final String CLASS_FILE_SUFFIX = ".class";

    private ReflectionUtils() {
    }

    public static Class<?>[] getClassesFromPackage(String packageName) throws IOException {
        return (Class[])ReflectionUtils.getFilesFromPackage(packageName).toArray(Class[]::new);
    }

    private static Stream<? extends Class<?>> getFilesFromPackage(String packageName) throws IOException {
        Predicate<File> onlyFiles = file -> !file.isDirectory();
        Path packagePath = ReflectionUtils.getFile(packageName).toPath();
        return Files.walk(packagePath, new FileVisitOption[0]).map(Path::toFile).filter(onlyFiles).map(ReflectionUtils::replaceSlashesWithDots).map(fullPath -> ReflectionUtils.extractFullyQualifiedClassName(fullPath, packageName)).map(ReflectionUtils::removeClassSuffix).map(ClassLoader::loadClass);
    }

    private static String replaceSlashesWithDots(File file) {
        return file.toString().replaceAll(Matcher.quoteReplacement(File.separator), PACKAGE_SEPARATOR);
    }

    private static String extractFullyQualifiedClassName(String fullPath, String packageName) {
        return fullPath.substring(fullPath.lastIndexOf(packageName));
    }

    private static String removeClassSuffix(String classFile) {
        int endIndex = classFile.length() - CLASS_FILE_SUFFIX.length();
        return classFile.substring(0, endIndex);
    }

    private static File getFile(String packageName) {
        String packagePath = packageName.replaceAll("\\.", FILE_SEPARATOR);
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(packagePath);
        if (fileUrl == null) {
            throw new PackageFilterException(packagePath, null);
        }
        return new File(fileUrl.getFile());
    }
}

