/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junitparams.InvokeParameterisedMethod;
import junitparams.ParameterisedTestMethodRunner;
import junitparams.Parameters;
import junitparams.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ParameterisedTestClassRunner {
    private Map<TestMethod, ParameterisedTestMethodRunner> parameterisedMethods = new HashMap<TestMethod, ParameterisedTestMethodRunner>();

    public List<FrameworkMethod> computeTestMethods(List<TestMethod> list, boolean parameterisedOnlyOnce) {
        ArrayList<FrameworkMethod> resultMethods = new ArrayList<FrameworkMethod>();
        for (TestMethod testMethod : list) {
            if (this.isParameterised(testMethod) && !parameterisedOnlyOnce) {
                this.addTestMethodForEachParamSet(resultMethods, testMethod);
                continue;
            }
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        return resultMethods;
    }

    private void addTestMethodForEachParamSet(List<FrameworkMethod> resultMethods, TestMethod testMethod) {
        ParameterisedTestMethodRunner parameterisedTestMethodRunner = new ParameterisedTestMethodRunner(testMethod);
        int paramSetSize = parameterisedTestMethodRunner.paramsFromAnnotation().length;
        for (int i = 0; i < paramSetSize; ++i) {
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        this.parameterisedMethods.put(testMethod, parameterisedTestMethodRunner);
    }

    private void addTestMethodOnce(List<FrameworkMethod> resultMethods, TestMethod testMethod) {
        resultMethods.add(testMethod.frameworkMethod);
    }

    public Statement parameterisedMethodInvoker(TestMethod method, Object testClass) {
        if (!this.isParameterised(method)) {
            return null;
        }
        ParameterisedTestMethodRunner parameterisedMethod = this.parameterisedMethods.get(method);
        return new InvokeParameterisedMethod(method.frameworkMethod, testClass, parameterisedMethod.currentParamsFromAnnotation(), parameterisedMethod.count());
    }

    public boolean shouldRun(TestMethod testMethod) {
        return this.isParameterised(testMethod);
    }

    public void runParameterisedTest(TestMethod method, Statement methodInvoker, RunNotifier notifier) {
        this.parameterisedMethods.get(method).runTestMethod(methodInvoker, notifier);
    }

    public Description describeParameterisedMethod(TestMethod testMethod) {
        if (!this.isParameterised(testMethod)) {
            return null;
        }
        return this.parameterisedMethods.get(testMethod).describeMethod();
    }

    public boolean isParameterised(TestMethod parameterObject) {
        return parameterObject.frameworkMethod.getMethod().isAnnotationPresent(Parameters.class);
    }
}

