/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    protected FrameworkMethod frameworkMethod;
    private Class<?> testClass;

    public TestMethod(FrameworkMethod method, TestClass testClass) {
        this.frameworkMethod = method;
        this.testClass = testClass.getJavaClass();
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    public static List<TestMethod> listFrom(List<FrameworkMethod> annotatedMethods, TestClass testClass) {
        ArrayList<TestMethod> methods = new ArrayList<TestMethod>();
        for (FrameworkMethod frameworkMethod : annotatedMethods) {
            methods.add(new TestMethod(frameworkMethod, testClass));
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestMethod)) {
            return false;
        }
        return this.frameworkMethod.equals((Object)((TestMethod)obj).frameworkMethod);
    }

    Class<?> testClass() {
        return this.testClass;
    }
}

