/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.reflect.Method;

class Utils {
    Utils() {
    }

    public static String stringify(Object paramSet, int paramIdx) {
        String result = "[" + paramIdx + "] ";
        result = paramSet instanceof String ? result + paramSet : result + Utils.asCsvString(Utils.safelyCastParamsToArray(paramSet), paramIdx);
        return Utils.trimSpecialChars(result);
    }

    private static String trimSpecialChars(String result) {
        return result.replace(System.getProperty("line.separator"), " ").replace('(', '[').replace(')', ']');
    }

    static Object[] safelyCastParamsToArray(Object paramSet) {
        Object[] params;
        try {
            params = (Object[])paramSet;
        }
        catch (ClassCastException e) {
            params = new Object[]{paramSet};
        }
        return params;
    }

    private static String asCsvString(Object[] params, int paramIdx) {
        String result = "";
        Object lastParam = params[params.length - 1];
        for (Object param : params) {
            result = Utils.addParamToResult(result, param);
            if (param == lastParam) continue;
            result = result + ", ";
        }
        return result;
    }

    private static String addParamToResult(String result, Object param) {
        if (param == null) {
            result = result + "null";
        } else {
            try {
                Utils.tryFindingOverridenToString(param);
                result = result + param.toString();
            }
            catch (Exception e) {
                result = result + param.getClass().getSimpleName();
            }
        }
        return result;
    }

    private static void tryFindingOverridenToString(Object param) throws NoSuchMethodException {
        Method toString = param.getClass().getMethod("toString", new Class[0]);
        if (toString.getDeclaringClass().equals(Object.class)) {
            throw new NoSuchMethodException();
        }
    }
}

