/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.annotation.Annotation;
import java.util.List;
import junitparams.internal.ParameterisedTestClassRunner;
import junitparams.internal.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitParamsRunner
extends BlockJUnit4ClassRunner {
    private ParameterisedTestClassRunner parameterisedRunner = new ParameterisedTestClassRunner(this.getTestClass());
    private Description description;

    public JUnitParamsRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        for (Throwable throwable : errors) {
            throwable.printStackTrace();
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.handleIgnored(method, notifier)) {
            return;
        }
        TestMethod testMethod = this.parameterisedRunner.testMethodFor(method);
        if (this.parameterisedRunner.shouldRun(testMethod)) {
            this.parameterisedRunner.runParameterisedTest(testMethod, this.methodBlock(method), notifier);
        } else {
            super.runChild(method, notifier);
        }
    }

    private boolean handleIgnored(FrameworkMethod method, RunNotifier notifier) {
        TestMethod testMethod = this.parameterisedRunner.testMethodFor(method);
        if (testMethod.isIgnored()) {
            notifier.fireTestIgnored(this.describeMethod(method));
        }
        return testMethod.isIgnored();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.parameterisedRunner.computeFrameworkMethods();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement methodInvoker = this.parameterisedRunner.parameterisedMethodInvoker(method, test);
        if (methodInvoker == null) {
            methodInvoker = super.methodInvoker(method, test);
        }
        return methodInvoker;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getTestClass().getAnnotations());
            List<FrameworkMethod> resultMethods = this.parameterisedRunner.returnListOfMethods();
            for (FrameworkMethod method : resultMethods) {
                this.description.addChild(this.describeMethod(method));
            }
        }
        return this.description;
    }

    protected Description describeMethod(FrameworkMethod method) {
        Description child = this.parameterisedRunner.describeParameterisedMethod(method);
        if (child == null) {
            child = this.describeChild(method);
        }
        return child;
    }

    public static Object[] $(Object ... params) {
        return params;
    }
}

