/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.type.NullType;
import junitparams.FileParameters;
import junitparams.Parameters;
import junitparams.internal.Utils;
import junitparams.mappers.DataMapper;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    private FrameworkMethod frameworkMethod;
    private Class<?> testClass;
    private Parameters parametersAnnotation;
    private FileParameters fileParametersAnnotation;
    private Object[] params;

    public TestMethod(FrameworkMethod method, TestClass testClass) {
        this.frameworkMethod = method;
        this.testClass = testClass.getJavaClass();
        this.parametersAnnotation = (Parameters)this.frameworkMethod.getAnnotation(Parameters.class);
        this.fileParametersAnnotation = (FileParameters)this.frameworkMethod.getAnnotation(FileParameters.class);
        if (this.parametersAnnotation != null && this.fileParametersAnnotation != null) {
            throw new IllegalArgumentException("Both @Parameters and @FileParameters exist on " + this.frameworkMethod.getName() + ". Remove one of them!");
        }
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    public static List<TestMethod> listFrom(List<FrameworkMethod> annotatedMethods, TestClass testClass) {
        ArrayList<TestMethod> methods = new ArrayList<TestMethod>();
        for (FrameworkMethod frameworkMethod : annotatedMethods) {
            methods.add(new TestMethod(frameworkMethod, testClass));
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestMethod)) {
            return false;
        }
        if (!this.frameworkMethod.getName().equals(((TestMethod)obj).frameworkMethod.getName())) {
            return false;
        }
        return this.frameworkMethod.getMethod().getParameterTypes().equals(((TestMethod)obj).frameworkMethod.getMethod().getParameterTypes());
    }

    Class<?> testClass() {
        return this.testClass;
    }

    public boolean isIgnored() {
        if (this.frameworkMethod.getAnnotation(Ignore.class) != null) {
            return true;
        }
        return this.isParameterised() && this.parametersSets().length == 0;
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public Annotation[] annotations() {
        return this.frameworkMethod.getAnnotations();
    }

    Description describe() {
        if (this.isNotIgnored() && !this.describeFlat()) {
            Description parametrised = Description.createSuiteDescription((String)this.name(), (Annotation[])new Annotation[0]);
            Object[] params = this.parametersSets();
            for (int i = 0; i < params.length; ++i) {
                Object paramSet = params[i];
                parametrised.addChild(Description.createTestDescription(this.testClass(), (String)(Utils.stringify(paramSet, i) + " (" + this.name() + ")"), (Annotation[])this.annotations()));
            }
            return parametrised;
        }
        return Description.createTestDescription(this.testClass(), (String)this.name(), (Annotation[])this.annotations());
    }

    private boolean describeFlat() {
        return System.getProperty("JUnitParams.flat") != null;
    }

    public Object[] parametersSets() {
        if (this.params != null) {
            return this.params;
        }
        if (this.parametersAnnotation != null) {
            this.params = this.paramsFromValue();
            if (this.params.length == 0) {
                this.params = this.paramsFromSource();
            }
            if (this.params.length == 0) {
                this.params = this.paramsFromMethod(this.testClass());
            }
        } else if (this.fileParametersAnnotation != null) {
            this.params = this.paramsFromFile();
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] paramsFromFile() {
        Object[] objectArray;
        Reader reader = this.createProperReader();
        DataMapper mapper = this.fileParametersAnnotation.mapper().newInstance();
        try {
            objectArray = mapper.map(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not successfully read parameters from file: " + this.fileParametersAnnotation.value(), e);
            }
        }
        reader.close();
        return objectArray;
    }

    private Reader createProperReader() throws IOException {
        String filepath = this.fileParametersAnnotation.value();
        if (filepath.indexOf(58) < 0) {
            return new FileReader(filepath);
        }
        String protocol = filepath.substring(0, filepath.indexOf(58));
        String filename = filepath.substring(filepath.indexOf(58) + 1);
        if ("classpath".equals(protocol)) {
            return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(filename));
        }
        if ("file".equals(protocol)) {
            return new FileReader(filename);
        }
        throw new IllegalArgumentException("Unknown file access protocol. Only 'file' and 'classpath' are supported!");
    }

    private Object[] paramsFromValue() {
        return this.parametersAnnotation.value();
    }

    private Object[] paramsFromSource() {
        if (this.sourceClassUndefined()) {
            return new Object[0];
        }
        Class<?> sourceClass = this.parametersAnnotation.source();
        String method = this.parametersAnnotation.method();
        if (method.isEmpty()) {
            return this.fillResultWithAllParamProviderMethods(sourceClass);
        }
        return this.paramsFromMethod(sourceClass);
    }

    private Object[] paramsFromMethod(Class<?> classWithMethod) {
        String methodAnnotation = this.parametersAnnotation.method();
        if (methodAnnotation.isEmpty()) {
            return this.invokeMethodWithParams(this.defaultMethodName(), classWithMethod);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String methodName : methodAnnotation.split(",")) {
            for (Object param : this.invokeMethodWithParams(methodName.trim(), classWithMethod)) {
                result.add(param);
            }
        }
        return result.toArray();
    }

    private boolean sourceClassUndefined() {
        return this.parametersAnnotation.source().isAssignableFrom(NullType.class);
    }

    private String defaultMethodName() {
        String methodName = "parametersFor" + this.frameworkMethod.getName().substring(0, 1).toUpperCase() + this.frameworkMethod.getName().substring(1);
        return methodName;
    }

    private Object[] invokeMethodWithParams(String methodName, Class<?> testClass) {
        Method provideMethod = this.findParamsProvidingMethodInTestclassHierarchy(methodName, testClass);
        return this.invokeParamsProvidingMethod(testClass, provideMethod);
    }

    private Method findParamsProvidingMethodInTestclassHierarchy(String methodName, Class<?> testClass) {
        Method provideMethod = null;
        Class<?> declaringClass = testClass;
        while (declaringClass.getSuperclass() != null) {
            try {
                provideMethod = declaringClass.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (Exception e) {
                declaringClass = declaringClass.getSuperclass();
            }
        }
        if (provideMethod == null) {
            throw new RuntimeException("Could not find method: " + methodName + " so no params were used.");
        }
        return provideMethod;
    }

    private Object[] invokeParamsProvidingMethod(Class<?> testClass, Method provideMethod) {
        try {
            Object testObject = testClass.newInstance();
            provideMethod.setAccessible(true);
            Object result = provideMethod.invoke(testObject, new Object[0]);
            if (Object[].class.isAssignableFrom(result.getClass())) {
                Object[] params = (Object[])result;
                return this.encapsulateParamsIntoArrayIfSingleParamsetPassed(params);
            }
            if (Iterable.class.isAssignableFrom(result.getClass())) {
                try {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    for (Object[] paramSet : (Iterable)result) {
                        res.add(paramSet);
                    }
                    return res.toArray();
                }
                catch (ClassCastException e1) {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    for (Object param : (Iterable)result) {
                        res.add(new Object[]{param});
                    }
                    return res.toArray();
                }
            }
            if (Iterator.class.isAssignableFrom(result.getClass())) {
                try {
                    ArrayList res = new ArrayList();
                    Iterator iterator = (Iterator)result;
                    while (iterator.hasNext()) {
                        res.add(iterator.next());
                    }
                    return res.toArray();
                }
                catch (ClassCastException e1) {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    Iterator iterator = (Iterator)result;
                    while (iterator.hasNext()) {
                        res.add(new Object[]{iterator.next()});
                    }
                    return res.toArray();
                }
            }
            throw new ClassCastException();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The return type of: " + provideMethod.getName() + " defined in class " + testClass + " is not Object[][] nor Iterable<Object[]>. Fix it!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke method: " + provideMethod.getName() + " defined in class " + testClass + " so no params were used.", e);
        }
    }

    private Object[] fillResultWithAllParamProviderMethods(Class<?> sourceClass) {
        List<Object> result = this.getParamsFromSourceHierarchy(sourceClass);
        if (result.isEmpty()) {
            throw new RuntimeException("No methods starting with provide or they return no result in the parameters source class: " + sourceClass.getName());
        }
        return result.toArray(new Object[0]);
    }

    private List<Object> getParamsFromSourceHierarchy(Class<?> sourceClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (sourceClass.getSuperclass() != null) {
            result.addAll(this.gatherParamsFromAllMethodsFrom(sourceClass));
            sourceClass = sourceClass.getSuperclass();
        }
        return result;
    }

    private List<Object> gatherParamsFromAllMethodsFrom(Class<?> sourceClass) {
        Method[] methods;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Method prividerMethod : methods = sourceClass.getDeclaredMethods()) {
            if (!prividerMethod.getName().startsWith("provide")) continue;
            if (!Modifier.isStatic(prividerMethod.getModifiers())) {
                throw new RuntimeException("Parameters source method " + prividerMethod.getName() + " is not declared as static. Change it to a static method.");
            }
            try {
                result.addAll(Arrays.asList(this.getDataFromMethod(prividerMethod)));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke parameters source method: " + prividerMethod.getName(), e);
            }
        }
        return result;
    }

    private Object[] getDataFromMethod(Method prividerMethod) throws IllegalAccessException, InvocationTargetException {
        return this.encapsulateParamsIntoArrayIfSingleParamsetPassed((Object[])prividerMethod.invoke(null, new Object[0]));
    }

    private Object[] encapsulateParamsIntoArrayIfSingleParamsetPassed(Object[] params) {
        if (this.frameworkMethod.getMethod().getParameterTypes().length != params.length) {
            return params;
        }
        if (params.length == 0) {
            return params;
        }
        Object param = params[0];
        if (param == null || !param.getClass().isArray()) {
            return new Object[]{params};
        }
        return params;
    }

    public boolean isParameterised() {
        return this.frameworkMethod.getMethod().isAnnotationPresent(Parameters.class) || this.frameworkMethod.getMethod().isAnnotationPresent(FileParameters.class);
    }

    void warnIfNoParamsGiven() {
        if (this.isNotIgnored() && this.isParameterised() && this.parametersSets().length == 0) {
            System.err.println("Method " + this.name() + " gets empty list of parameters, so it's being ignored!");
        }
    }

    public FrameworkMethod frameworkMethod() {
        return this.frameworkMethod;
    }
}

