/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Method;

public class Utils {
    public static final String REGEX_ALL_NEWLINES = "(\\r\\n|\\n|\\r)";

    public static String stringify(Object paramSet, int paramIdx) {
        String result = "[" + paramIdx + "] ";
        result = paramSet == null ? result + "null" : (paramSet instanceof String ? result + paramSet : result + Utils.asCsvString(Utils.safelyCastParamsToArray(paramSet), paramIdx));
        return Utils.trimSpecialChars(result);
    }

    private static String trimSpecialChars(String result) {
        return result.replace('(', '[').replace(')', ']').replaceAll(REGEX_ALL_NEWLINES, " ");
    }

    static Object[] safelyCastParamsToArray(Object paramSet) {
        Object[] params;
        if (paramSet instanceof String[]) {
            params = new Object[]{paramSet};
        } else {
            try {
                params = (Object[])paramSet;
            }
            catch (ClassCastException e) {
                params = new Object[]{paramSet};
            }
        }
        return params;
    }

    private static String asCsvString(Object[] params, int paramIdx) {
        if (params == null) {
            return "null";
        }
        if (params.length == 0) {
            return "";
        }
        String result = "";
        for (int i = 0; i < params.length - 1; ++i) {
            Object param = params[i];
            result = Utils.addParamToResult(result, param) + ", ";
        }
        result = Utils.addParamToResult(result, params[params.length - 1]);
        return result;
    }

    private static String addParamToResult(String result, Object param) {
        if (param == null) {
            result = result + "null";
        } else {
            try {
                Utils.tryFindingOverridenToString(param);
                result = result + param.toString();
            }
            catch (Exception e) {
                result = result + param.getClass().getSimpleName();
            }
        }
        return result;
    }

    private static void tryFindingOverridenToString(Object param) throws NoSuchMethodException {
        Method toString = param.getClass().getMethod("toString", new Class[0]);
        if (toString.getDeclaringClass().equals(Object.class)) {
            throw new NoSuchMethodException();
        }
    }
}

