/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import junitparams.custom.ParametersProvider;
import junitparams.internal.annotation.CustomParametersDescriptor;
import junitparams.internal.annotation.FrameworkMethodAnnotations;
import junitparams.internal.parameters.ParametrizationStrategy;
import org.junit.runners.model.FrameworkMethod;

class ParametersFromCustomProvider
implements ParametrizationStrategy {
    private final FrameworkMethodAnnotations frameworkMethodAnnotations;
    private final FrameworkMethod frameworkMethod;

    ParametersFromCustomProvider(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
        this.frameworkMethodAnnotations = new FrameworkMethodAnnotations(frameworkMethod);
    }

    @Override
    public boolean isApplicable() {
        return this.frameworkMethodAnnotations.hasCustomParameters();
    }

    @Override
    public Object[] getParameters() {
        CustomParametersDescriptor parameters = this.frameworkMethodAnnotations.getCustomParameters();
        ParametersProvider provider = this.instantiate(parameters.provider());
        provider.initialize(parameters.annotation(), this.frameworkMethod);
        return provider.getParameters();
    }

    private ParametersProvider instantiate(Class<? extends ParametersProvider> providerClass) {
        try {
            return providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ignored) {
            throw new RuntimeException("Your Provider class must have a public no-arg constructor!");
        }
    }
}

